#include <iostream>
 #include <algorithm>
 
 using namespace std;
 
 bool is_correct(vector<vector<bool>> &skills, vector<bool> occupied, vector<int> remaining) {
     for (int i: remaining) {
         bool found = false;
         for (int j = 0; j < skills.size(); ++j) {
             if (occupied[j]) continue;
 
             if (skills[i][j]) {
                 found = true;
                 vector<bool> new_occupied = occupied;
                 new_occupied[j] = true;
                 vector<int> new_remaining = remaining;
                 new_remaining.erase(find(new_remaining.begin(), new_remaining.end(), i));
                 bool there_result = is_correct(skills, new_occupied, new_remaining);
                 if (!there_result) return false;
             }
         }
         if (!found) return false;
     }
     return true;
 }
 
 int cost(vector<vector<bool>> &skills_a, vector<vector<bool>> &skills_b) {
     int result = 0;
     for (int i = 0; i < skills_a.size(); ++i) {
         for (int j = 0; j < skills_a.size(); ++j) {
             if (skills_a[i][j] != skills_b[i][j]) result += 1;
         }
     }
     return result;
 }
 
 int main() {
     int t;
     cin >> t;
 
     for (int q = 1; q <= t; ++q) {
         int n;
         cin >> n;
 
         vector<vector<bool>> orig(n, vector<bool>(n));
         for (int i = 0; i < n; ++i) {
             string row;
             cin >> row;
             for (int j = 0; j < n; ++j) {
                 orig[i][j] = (row[j] == '1');
             }
         }
 
         vector<bool> occupied(n, false);
         vector<int> remaining(n);
         for (int i = 0; i < n; ++i) {
             remaining[i] = i;
         }
 
         int best = -1;
 
         for (int arr = 0; arr < (1 << (n * n)); ++arr) {
             vector<vector<bool>> chg(n, vector<bool>(n));
             for (int i = 0; i < n; ++i) {
                 for (int j = 0; j < n; ++j) {
                     int index = i * n + j;
                     chg[i][j] = (arr & (1 << index));
                 }
             }
 
             if (is_correct(chg, occupied, remaining)) {
                 int c = cost(orig, chg);
                 if (best == -1 || c < best) best = c;
             }
         }
 
         cout << "Case #" << q << ": " << best << endl;
     }
 }
