#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 #define MAX_SIZE 1001
 
 int solve(char *string, int K);
 void flip(char *string, int start, int len);
 
 int main()
 {
 
 	int T, K;
 	int cnt;
 	char S[MAX_SIZE + 1];
 	int ret;
 
 	scanf("%d", &T);
 	for (cnt = 0; cnt < T; cnt++) {
 		memset(S, 0, sizeof(S));
 		scanf("%s", S);
 		scanf("%d", &K);
 
 		ret = solve(S, K);
 		if (ret == -1)
 			printf("Case #%d: IMPOSSIBLE\n", cnt+1);
 		else
 			printf("Case #%d: %d\n", cnt+1, ret);
 	}
 
 	return 0;
 }
 
 
 int solve(char *string, int K)
 {
 	int cnt;
 	int i;
 	int len;
 
 	cnt = 0;
 	len = strlen(string);
 	for (i=0; i<= len - K; i++) {
 		if (string[i] == '-') {
 			flip(string, i, K);
 			cnt++;
 		}
 	}
 
 	for (; i<len; i++) {
 		if (string[i] == '-')
 			return -1;
 	}
 
 	return cnt;
 }
 
 void flip(char *string, int start, int len)
 {
 	int i;
 
 	for (i=start; i < start + len; i++) {
 		if (string[i] == '-')
 			string[i] = '+';
 		else
 			string[i] = '-';
 	}
 }
 
