#include <stdio.h>
 #include <string.h>
 #include <stdbool.h>
 #include <assert.h>
 
 #define S 1000
 
 bool flip(char pancakes[S], int index, int count, int boundary){
 	for(int i = 0; i < count; i++){
 		if(index + i >= boundary){
 			return false;
 		}
 
 		char *target = &pancakes[index + i];
 		switch(*target){
 			case '+':
 				*target = '-';
 				break;
 			case '-':
 				*target = '+';
 				break;
 			default:
 				assert(0);
 		}
 	}
 
 	return true;
 }
 
 void solve(int caseId, char pancakes[S], int count){
 	int flipped = 0;
 	int boundary = strnlen(pancakes, S);
 
 	for(int i = 0; i < 1000; i++){
 		if(pancakes[i] == 0){
 			break;
 		}
 
 		if(pancakes[i] == '-'){
 			if(!flip(pancakes, i, count, boundary)){
 				printf("Case #%d: IMPOSSIBLE\n", caseId);
 				return;
 			}
 			flipped++;
 		}
 	}
 
 	printf("Case #%d: %d\n", caseId, flipped);
 }
 
 int main(){
 	int cases;
 
 	scanf("%d", &cases);
 
 	for(int i = 0; i < cases; i++){
 		char testcase[S];
 		int count;
 		scanf("%s", &testcase);
 		scanf("%d", &count);
 
 		solve(i+1, testcase, count);
 	}
 
 	return 0;
 }
