// gcc -std=c99 -o A A.c
 #include <assert.h>
 #include <stdio.h>
 #include <string.h>
 
 // K pancakes starting from S[i]
 void
 flip(char* S, int i, int K)
 {
   for (int j = i; j < i + K; ++j) {
     S[j] = S[j] == '+' ? '-' : '+';
   }
 }
 
 void
 solve(void)
 {
   char S[1001];
   int K = 0;
   int res = scanf("\n%1000s %d", S, &K);
   assert(res == 2);
   int len = strlen(S);
 
   int nFlips = 0;
 
   // rightmost position for left edge of pancake flipper
   int rightmost = len - K;
 
   // from left to right, flip every blank with left edge of pancake flipper
   for (int i = 0; i <= rightmost; ++i) {
     if (S[i] == '-') {
       ++nFlips;
       flip(S, i, K);
     }
   }
 
   // is there any blanks remaining?
   if (strchr(S + rightmost, '-') != NULL) {
     printf("IMPOSSIBLE");
   }
   else {
     printf("%d", nFlips);
   }
 }
 
 int
 main(void)
 {
   int T = 0;
   int res = scanf("%d", &T);
   assert(res == 1);
 
   for (int CASE = 1; CASE <= T; ++CASE) {
     printf("Case #%d: ", CASE);
     solve();
     printf("\n");
   }
 }
