#include <stdio.h>
 #include <stdlib.h>
 #include <stdbool.h>
 
 bool AllTheSame(char* row, int min, int max) {
     for (int i = min + 1; i < max + 1; i++) {
         if (row[i - 1] != row[i]) {
             return false;
         }
     }
 
     return true;
 }
 
 unsigned int FlipRange(char* row, int lastPlus, int low, int high) {
     unsigned int res = 0;
     int min = low;
     int max = high;
 
 #if 0
     if (lastPlus != -1 && lastPlus < low) {
         for (int i = 0; i <= lastPlus; i++) {
             row[i] = '-';
         }
 
         res += 1;
         min = 0;
     }
 #endif
 
     for (int i = min; i <= max; i++) {
         if (row[i] == '-')
             row[i] = '+';
         else
             row[i] = '-';
     }
 
     res += 1;
 
     return res;
 }
 
 int main(int argc, char* argv[]) {
     char* row = (char *) calloc(1000, sizeof(char));
     int c;
     unsigned int n;
     unsigned int flipperSize;
     int t;
     unsigned int moves = 0;
 
     scanf("%d ", &t);
 
     for (int i = 0; i < t; i++) {
         n = 0;
         moves = 0;
 
         while ((c = getchar()) != ' ')
             row[n++] = c;
 
         scanf(" %d", &flipperSize);
 
         int lowMinus = -1, highMinus = -1;
         int lastPlus = -1;
 
         for (int j = 0; j < n; j++) {
             if (j + flipperSize == n) {
                 if (AllTheSame(row, j, n - 1)) {
                     if (row[j] == '-') {
                         moves++;
                     }
 
                     printf("Case #%d: %u\n", i + 1, moves);
                     break;
                 }else {
                     printf("Case #%d: IMPOSSIBLE\n", i + 1);
                     break;
                 }
             }else {
                 if (row[j] == '-') {
                     if (lowMinus == -1) {
                         lowMinus = j;
                         highMinus = j + flipperSize - 1;
                         moves += FlipRange(row, lastPlus, lowMinus, highMinus);
                         lowMinus = -1;
                         highMinus = -1;
                     }
                 }
             }
         }
  
     }
 
     return 0;
 }
