#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <math.h>
 
 
 #define MAX 10000
 #define ERROR -99
 
 void usage(){
   printf("too few arguments !\n");  
 }
 
 long long unsigned int ascii_convertion(char *c, long long unsigned int beginning, long long unsigned int length){
   long long unsigned int i = 0;
   long long unsigned int number = 0;
   if(length-beginning == 1) return (c[beginning]-48);
   for(i = beginning ; i < length ; i++){
     if(c[i] > 58 || c[i] < 48)
       return -1;
     number += ((int)c[i]-48) * pow(10, length-i-1-beginning);
   }
   return number;
 }
 
 void string_to_binary(long long unsigned int *array, long long unsigned int length, char *string){
   int i = 0;
   for(i = 0 ; i< length ; i++){
     if(string[i] == '+')
       array[i] = 1;
     else 
       array[i] = 0;
   }  
 }
 
 void end(long long unsigned int *array, long long unsigned int length){
   int i = 0;
   for(i = 0 ; i < length ; i ++){
     array[i] = 1;
   }  
 }
 
 void array_print(long long unsigned int *array, long long unsigned int length){
   int i = 0; 
   for(i = 0; i < length ; i++){
     printf("%llu ", array[i]);
   }
   printf("\n");
 }
 
 int array_cmp(long long unsigned int *S,long long unsigned int *exit, long long unsigned int length){
   int i = 0;
   for(i  = 0 ; i < length ; i++){
     if(S[i] != exit[i])
       return 1;
   }
   return 0;
 }
 
 long long unsigned int first_blank(long long unsigned int *S, long long unsigned int length){
   long long unsigned int i = 0;
   for(i= 0 ; i < length ; i++){
     if(S[i] == 0)
       return i;
   }  
   return ERROR;
 }
 
 int more_than_k_end_blank(long long unsigned int *S, long long unsigned int beginning, long long unsigned int end, long long unsigned int k){
   return (beginning+k > end);  
 }
 
 void flip(long long unsigned int *S, long long unsigned int beginning, long long unsigned int k){
   long long unsigned int i = 0;
   for(i = beginning; i < beginning+k  ;i++){
     if(S[i] == 0)
       S[i] = 1;
     else 
       S[i] = 0;    
   }
 }
 
 void array_copy(long long unsigned int *S, long long unsigned int *t, long long unsigned int length){
   long long unsigned int i= 0;
   for(i = 0 ; i < length ; i++){
     t[i] = S[i];
   }  
 }
 
 int is_complementary(long long unsigned int *S, long long unsigned int *exit, long long unsigned int length,long long unsigned int k){
   long long unsigned int tmp[MAX];
   array_copy(S, tmp, length);
   flip(tmp, 0, length);
   
   if(length == k && (!array_cmp(S, exit, length)  || !array_cmp(tmp, exit, length) ) )
     return 1;
   return 0;
 }
 
 void reverse_array(long long unsigned int *S,long long unsigned int length){
   long long unsigned  int tmp[MAX];
   array_copy(S, tmp, length);
   long long unsigned int  i = 0;
   
   for(i = length-1 ; i >=0 ; i--)
     S[i] = tmp[length-i-1];
 }
 
 
 
 int main(int argc, char *argv[]){
   if(argc < 2){
     usage();
     return 1;
   }
   
   long long unsigned int S[MAX] = {0};
   long long unsigned int n = argc-2;
   char K[MAX] = "\0";
   long long unsigned int i = 0,/*k = 0,*/ line = 0, nbTentative = 0;
   long long unsigned int lenS = 0, lenK = 0, intK = 0;
   long long unsigned int exit[MAX] = {0};
   end(exit, MAX);
   
   for(i = 2 ; i <= n ; i = i + 2){
     
     nbTentative = 0;
     line++;
     lenS = strlen(argv[i]);  
     string_to_binary(S, lenS, argv[i]);
     
     strcpy(K, argv[i+1]);
     
     lenK = strlen(K);
     intK = ascii_convertion(K, 0, lenK);
     
     while(1){
       
       if(!array_cmp(S, exit, lenS)){
 	
 	printf("Case #%llu: %llu\n", line, nbTentative);
 	break;
       }
       
       int beginning = first_blank(S, lenS); 
       if(beginning== ERROR) return ERROR;
        
       if(lenS == intK){
 	long long unsigned int tmp[MAX];
 	array_copy(S, tmp, lenS);
 	flip(tmp, 0, intK);
 	nbTentative++;
 	if(!array_cmp(tmp, exit, lenS)){
 	  
 	  printf("Case #%llu: %llu\n", line, nbTentative);
 	  break;
 	}
 	
       }
       
       if(more_than_k_end_blank(S, beginning, lenS, intK) || is_complementary(S, exit, lenS, intK)){
 	printf("Case #%llu: IMPOSSIBLE\n", line);
 	break;
       }
       
       flip(S, beginning, intK);
       nbTentative++;
       
     }
     
   }
   
   return 0;
 }
