#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <unistd.h>
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <fcntl.h>
 
 int calc(char *p, int k)
 {
 	int i, t, len, count = 0;
 	len = strlen(p);
 	//printf("p1=%s,k=%d", p, k);
 	for(i=0; i < (len-(k-1));i++) {
 		if(p[i] == '+') continue;
 
 		p[i] = '+';
 		count++;
 		for(t = 1;t < k; t++) p[i+t] = p[i+t] == '-'?'+':'-';
 	}
 
 	//printf(",out=%s, count=%d\n", p, count);
 	if(strstr(p,"-")) return -1;
 	return count;
 }
 
 int lineCnt = 0;
 int totalTestCnt = 0;
 int readLine(char *p)
 {
 	char buf[1024];
 	int k, cnt;
 
 	if(!p || !strlen(p)) return -1;
 
 	if(sscanf(p, "%s %d", buf, &k) != 2) {
 		int testCnt = atoi(p);
 		if(!testCnt) return -2;
 		if(testCnt > 100) return -3;
 		totalTestCnt = testCnt;
 		return 0;
 	}
 
 	lineCnt++;
 
 	cnt = calc(buf,k);
 	if(cnt < 0) printf("Case #%d: IMPOSSIBLE\n", lineCnt);
 	else        printf("Case #%d: %d\n", lineCnt, cnt);
 	return 0;
 }
 
 #define FLEN (1024*100)
 int main(int ac, char **av)
 {
 	int fd;
 	if(ac < 2 || !strlen(av[1])) {
 		perror("input file");
 		return 0;
 	}
 
 	fd = open(av[1],O_RDONLY);
 	char c[FLEN];
 
 	read(fd, c, FLEN);
 	close(fd);
 
 	char *p, *sp;
 	p = sp = c;
 	while((p = strstr(p,"\n"))) {
 		*p = 0;
 		if(readLine(sp) < 0) break;
 		if(!totalTestCnt) break;
 		p++;
 		sp = p;
 		totalTestCnt--;
 	}
 }
