#include <stdio.h>
 #include <string.h>
 
 int solve(char *s, int k);
 void flip(char *s, int k, int start);
 void flip_reverse(char *s, int k, int start);
 int check(char *s);
 
 int main(int argc, char *argv[]) {
   FILE *in = fopen("oversized-pancake-flipper.in", "r");
   FILE *out = fopen("oversized-pancake-flipper.out", "w");
 
   int t;
   fscanf(in, "%d", &t);
   for (int i = 1; i <= t; i++) {
     char s[10000];
     int k;
     fscanf(in, "%s %d", s, &k);
     int result = solve(s, k);
     fprintf(out, "Case #%d: ", i);
     if (result != -1) {
     fprintf(out, "%d\n", result);
     } else {
       fprintf(out, "IMPOSSIBLE\n");
     }
   }
 
   fclose(in);
   fclose(out);
 
   return 0;
 }
 
 int solve(char *s, int k) {
   int flips = 0;
   int i = 0, j = strlen(s);
   while (j != 0 && i != strlen(s)) {
     if (s[i] == '-') {
       flip(s, k, i);
       flips++;
     }
     i++;
     if (s[j] == '-') {
       flip_reverse(s, k, j);
       flips++;
     }
     j--;
   }
   if (!check(s)) {
     return -1;
   }
   return flips;
 }
 
 void flip(char *s, int k, int start) {
   if (start + k > strlen(s)) {
     return;
   }
   for (int i = 0; i < k; i++) {
     s[i + start] = s[i + start] == '-' ? '+' : '-';
   }
 }
 
 void flip_reverse(char *s, int k, int start) {
   if (start - k < 0) {
     return;
   }
   for (int i = 0; i < k; i++) {
     s[start-i] = s[start-i] == '-' ? '+' : '-';
   }
 }
 
 int check(char *s) {
   for (int i = 0; i < strlen(s); i++) {
     if (s[i] == '-') {
       return 0;
     }
   }
   return 1;
 }
