//
 //  main.c
 //  Google Code Jam
 //
 //  Created by Konstantinos Mitropoulos on 8/4/2017.
 //  Copyright © 2017 NTUA. All rights reserved.
 //
 
 #include <stdio.h>
 #include <limits.h>
 
 
 
 void read_tests (FILE *fp, int *t)
 {
     fscanf(fp, "%d", t);
     getc(fp);
     return;
 }
 
 int read_grill (FILE *fp, char grill[])  {
     
     char c;
     int i = 0;
     while ((c = getc(fp)) && (c == '-' || c == '+' || c == '\n')) {
         if (c != '\n') grill[i++] = c;
     }
     return i-1;
 }
 
 void flip (char grill[], int index, int k)    {
     
     for (int j = index; j <= index+k; j++) {
         if (grill[j] == '-') grill[j] = '+';
         else grill[j] = '-';
     }
     return;
 }
 
 int check (char grill[], int max_index)    {
     int i = 0;
     while (i <= max_index) {
         if (grill [i++] == '-')   return 0;
     }
     return 1;
 }
 
 int flipping_fun (char grill[], int max_index, int k)    {
     int moves = 0;
     int index = 0;
     
     while (index+k-1 <= max_index) {
         if (grill[index] == '-')    {
             flip(grill, index, k-1);
             moves++;
         }
         index++;
     }
     
     if (check(grill, max_index) == 1)   return moves;
     else return -1;
 }
 
 
 int main(int argc, const char * argv[]) {
     
     FILE *fp, *fw;
     int T = -1;
     fp = fopen("/Users/konstantinos/Downloads/A-large.in.txt", "r");
     fw = fopen("/Users/konstantinos/Desktop/results.txt", "w");
     read_tests(fp, &T);
     char grill[1000] = {0};
     
     for (int i = 0; i < T; i++) {
         
         int max_index = read_grill(fp, grill);
         int k;
         fscanf(fp, "%d", &k);
         int moves = flipping_fun(grill, max_index, k);
         
         if (moves == -1) fprintf(fw, "Case #%d: IMPOSSIBLE\n", i+1);
         else fprintf(fw, "Case #%d: %d\n", i+1, moves);
     }
     
     return 0;
 }
