#include <stdio.h>
 #include <stdbool.h>
 #include <math.h>
 #include <string.h>
 
 #define MAXNUMBERVALUE 1000
 #define MAXTESTCASES 100
 
 int main(void) {
    int inpNum = 0;
    char inpStr[MAXNUMBERVALUE+1];
    int numTestCases = 0;
 
    // Get the number of test cases
    scanf("%i", &inpNum);
    numTestCases = inpNum;
    if (numTestCases < 1) {
       printf("ERROR: less than 1 test case specified\n");
       return -1;
    }
    else if (numTestCases > MAXTESTCASES) {
       printf("ERROR: more than %i test cases specified\n", MAXTESTCASES);
       return -2;
    }
 
    for (int i = 0; i < numTestCases; i++) {
       // Get beginning pakecake layout
       scanf("%s", inpStr);
       // Get pancake flipper width
       scanf("%i", &inpNum);
       printf("Case #%i: ", i+1);
       int numPancakes = strlen(inpStr);
       if (numPancakes > MAXNUMBERVALUE || inpNum > numPancakes) {
          printf("ERROR - larger than allowed value of %i\n", MAXNUMBERVALUE);
          continue;
       }
       else if (inpNum < 1) {
          printf("ERROR - less than 1\n");
          continue;
       }
       //printf("stack: %s  flipper size: %i\n", inpStr, inpNum);
       bool done = false;
       int numFlips = 0;
       while (!done) {
          bool foundUnhappy = false;
          for (int j = 0; j < numPancakes; j = j + 1) {
             if (inpStr[j] == '-') {
                foundUnhappy = true;
                if (j+inpNum > numPancakes) {
 	          printf("IMPOSSIBLE\n");
 	          done = true;
 	          break;
                }
                numFlips = numFlips + 1;
                for (int k = j; k < j+inpNum; k = k + 1) {
                   if (inpStr[k] == '-') {
                      inpStr[k] = '+';
                   }
                   else {
                      inpStr[k] = '-';
                   }
                }
 //printf("stack update: %s\n", inpStr);
             } 
          }
          if (!foundUnhappy) {
             printf("%i\n", numFlips);
             done = true;
          }
       }
    }
    return 0;
 }
