#include <stdio.h>
 #include <string.h>
 
 #define MAX_LENGTH 1001
 
 char s[MAX_LENGTH];
 
 char* flip(char *p, int k)
 {
 	char* n = p + k;
 	int f = 0;
 
 	while (k-- > 0)
 	{
 		switch (*p)
 		{
 			case 0: 
 				return NULL;
 
 			case '+':
 				*p = '-';
 				if (!f) 
 				{
 					n = p;
 					f = 1;
 				}
 				break;
 
 			case '-':
 				*p = '+';
 				break;
 		}
 		p++;
 	}
 	return n;
 }
 
 int count(char* p, int k)
 {
 	int c = 0;
 
 	while (p && *p)
 	{
 		switch (*p)
 		{
 			case '+':
 				p++;
 				break;
 
 			case '-':
 				p = flip(p, k);
 #ifdef DEBUG
 				printf("%d, %d : %s\n", (int)(p - s), k, s);
 #endif /* DEBUG */
 				c++;
 				if (!p) c = -1; /* IMPOSSIBLE */
 				break;
 		}
 	}
 
 	return c;
 }
 
 int main() 
 {
 	int i, t, k, c;
 
 	scanf("%d", &t);
 
 	for (i = 1; i <= t; ++i) 
 	{
 		memset(s, 0, MAX_LENGTH);
 
 		scanf("%s %d", s, &k);
 
 		c = count(s, k);
 
 		printf ("Case #%d: ", i);
 		if (c >= 0)
 			printf("%d\n", c);
 		else
 			printf("IMPOSSIBLE\n");
 	}
 
 	return 0;
 }
 
