#include <stdio.h>
 #include <string.h>
 
 static int
 get_min_flip_count (char *row, int fsz)
 {
     int i, j, k, len, blank_seen, cnt;
     int next;
 
     len = strlen(row);
     if (len < fsz) {
         return -1;
     }
 
     cnt = 0;
     for (i = 0; i < (len - fsz + 1); i = next) {
         blank_seen = k = next = 0;
         for (j = i; j < (i + fsz); j++) {
             if (row[j] == '-') {
                 blank_seen = 1;
                 k = j;
                 break;
             }
         }
 
         if (blank_seen) {
             if (k + fsz > len)
                 return -1;
             cnt++;
         } else {
             next = i + fsz;
             continue;
         }
 
         for (j = k; j < (k + fsz); j++) {
             if (row[j] == '-') {
                 row[j] = '+';
             } else {
                 row[j] = '-';
                 if (!next)
                     next = j;
             }
         }
 
         if (!next) {
             next = k + fsz;
         }
     }
 
     for (; i < len; i++) {
         if (row[i] == '-') {
             cnt = -1;
             break;
         }
     }
 
     return cnt;
 }
 
 int
 main (void)
 {
     int n, k, cnt, i;
     char row[1001];
 
     scanf("%d\n", &n);
     for (i = 0; i < n; i++) {
         scanf("%s %d\n", row, &k);
         cnt = get_min_flip_count(row, k);
         if (cnt >= 0) {
             printf("Case #%d: %d\n", i + 1, cnt);
         } else {
             printf("Case #%d: IMPOSSIBLE\n", i + 1);
         }
     }
 
     return 0;
 }
