#include <stdio.h>
 #include <stdlib.h>
 #include <stdbool.h>
 #include <string.h>
 
 // is_flipped(S,len) returns true if S contains only '+' chars, false otherwise.
 bool is_flipped(char *S, int len) {
     for (int i = 0; i < len; ++i) {
         if (S[i] == '-') return false;
     }
     return true;
 }
 
 // flip_next(S,len,K,state) flips the next K pancakes, if space allows.
 // Mutates state if K > len-i
 void flip_next(char *S, int len, int K, int *state) {
     for (int i = 0; i < len; ++i) {
         if (S[i] == '-') {
             if ((len-i) < K) {
                 *state = 1;
                 break;
             }
             int j = i;
             for (int k = 0; k < K; ++k) {
                 if (S[j] == '-') {
                     S[j] = '+';
                 } else {
                     S[j] = '-';
                 }
                 ++j;
             }
             break;
         }
     }
 }
 
 // flip_pancake(i,S,len,K) flips a pancake.
 int flip_pancake(int i, char *S, int len, int K) {
     int state = 0;
 
     int j = 0;
     while (1) {
         if (is_flipped(S, len)) {
             printf("Case #%d: %d\n", i, j);
             return 0;
         }
         flip_next(S, len, K, &state);
         if (state) {
             printf("Case #%d: IMPOSSIBLE\n", i);
             return 0;
         }
         ++j;
     }
 }
 
 int main(int argc, char const *argv[]) {
     int T, K, ret;
     char S[1010];
 
     FILE *input = fopen(argv[1], "r");
   	if (input == NULL) {
   		fprintf(stderr, "Error: Failed to open input file.\n");
   		exit(EXIT_FAILURE);
   	}
 
     if (fscanf(input, "%d", &T) == 1) {
         for (int i = 1; i <= T; ++i) {
             if (fscanf(input, "%s %d", S, &K) == 2) {
                 ret = flip_pancake(i, S, strlen(S), K);
             }
         }
     }
 
     fclose(input);
     return 0;
 }
