#include <fstream>
 #include <string>
 #include <iostream>
 #include <sstream>
 #include <vector>
 
 struct OneTry
 {
 	OneTry(const OneTry& initial)
 	{
 		m_pancakeRaw = initial.m_pancakeRaw;
 		m_flipperSize = initial.m_flipperSize;
 		m_flips = initial.m_flips;
 	}
 	OneTry(std::string line)
 	{
 		int whitespacePos = line.find(' ');
 		m_pancakeRaw = std::string(line.begin(), line.begin() + whitespacePos);
 		m_flipperSize = std::stoi(std::string(line.begin() + whitespacePos + 1, line.end()));
 		m_flips = 0;
 	}
 	bool Flip(int pos)
 	{
 		for (int i = 0; i < m_flipperSize; i++)
 		{
 			if (m_pancakeRaw.at(pos + i) == '-')
 			{
 				m_pancakeRaw.at(pos + i) = '+';
 			}
 			else if (m_pancakeRaw.at(pos + i) == '+')
 			{
 				m_pancakeRaw.at(pos + i) = '-';
 			}
 		}
 		m_flips++;
 		if (m_pancakeRaw.find('-') == std::string::npos)
 		{
 			return true;
 		}
 		return false;
 	}
 	bool IsPlusAndMinusNear()
 	{
 		if (m_pancakeRaw.find("+-+") != std::string::npos)
 		{
 			return true;
 		}
 		return false;
 	}
 	bool IsBad2()
 	{
 		if (m_flipperSize != 2)
 		{
 			return false;
 		}
 		/*if (m_pancakeRaw.at(0) == '-' && m_pancakeRaw.at(1) == '+' && m_pancakeRaw.at(2) == '+' && m_pancakeRaw.at(3) == '+')
 		{
 			return true;
 		}
 		int size = m_pancakeRaw.size();
 		if (m_pancakeRaw.at(size - 1) == '-' && m_pancakeRaw.at(size - 2) == '+' && m_pancakeRaw.at(size - 3) == '+' && m_pancakeRaw.at(size - 4) == '+')
 		{
 			return true;
 		}*/
 		if (m_pancakeRaw.find("+-+-") != std::string::npos)
 		{
 			return true;
 		}
 		if (m_pancakeRaw.find("-+-+") != std::string::npos)
 		{
 			return true;
 		}
 		return false;
 	}
 
 	std::string m_pancakeRaw;
 	int m_flipperSize;
 	int m_flips;
 };
 
 
 int main()
 {
 	std::ifstream infile("D:\\Projects\\input1_17.txt");
 	std::ofstream outfile("D:\\Projects\\output1_17.txt");
 
 	std::string line;
 	std::getline(infile, line);
 	int testCaseNum = std::stoi(line);
 	std::string impossible = "IMPOSSIBLE";
 
 	for (int n = 0; n < testCaseNum; n++)
 	{
 		std::getline(infile, line);
 		OneTry initial(line);
 		if (initial.m_pancakeRaw.find('-') == std::string::npos)
 		{
 			std::cout << "Case #" << n + 1 << ": " << 0 << std::endl;
 			outfile << "Case #" << n + 1 << ": " << 0 << std::endl;
 			continue;
 		}
 		if (initial.m_flipperSize > initial.m_pancakeRaw.size())
 		{
 			std::cout << "Case #" << n + 1 << ": " << impossible << std::endl;
 			outfile << "Case #" << n + 1 << ": " << impossible << std::endl;
 			continue;
 		}
 		if (initial.m_flipperSize == 2 && initial.IsPlusAndMinusNear())
 		{
 			std::cout << "Case #" << n + 1 << ": " << impossible << std::endl;
 			outfile << "Case #" << n + 1 << ": " << impossible << std::endl;
 			continue;
 		}
 		if (initial.m_flipperSize == initial.m_pancakeRaw.size())
 		{
 			if (initial.IsPlusAndMinusNear())
 			{
 				std::cout << "Case #" << n + 1 << ": " << impossible << std::endl;
 				outfile << "Case #" << n + 1 << ": " << impossible << std::endl;
 				continue;
 			}
 			else
 			{
 				std::cout << "Case #" << n + 1 << ": " << 1 << std::endl;
 				outfile << "Case #" << n + 1 << ": " << 1 << std::endl;
 				continue;
 			}
 		}
 		if (initial.IsBad2())
 		{
 			std::cout << "Case #" << n + 1 << ": " << impossible << std::endl;
 			outfile << "Case #" << n + 1 << ": " << impossible << std::endl;
 			continue;
 		}
 		
 		int numberFlipsPossible = initial.m_pancakeRaw.size() - initial.m_flipperSize + 1;
 		int result = 0;
 		std::vector<OneTry> currentTries;
 		currentTries.push_back(initial);
 		for (int i = 0; i < 5; i++)
 		{
 			std::vector<OneTry> previousTries = currentTries;
 			currentTries.clear();
 			for (int iter = 0; iter < previousTries.size(); ++iter)
 			{
 				for (int flip = 0; flip < numberFlipsPossible; ++flip)
 				{
 					OneTry newTry(previousTries.at(iter));
 					bool res = newTry.Flip(flip);
 					currentTries.push_back(newTry);
 					if (res)
 					{
 						result = newTry.m_flips;
 						break;
 					}
 				}
 				if (result)
 				{
 					break;
 				}
 			}
 			if (result)
 			{
 				break;
 			}
 		}
 		
 		
 		if (result == 0)
 		{
 			std::cout << "Case #" << n + 1 << ": " << impossible << std::endl;
 			outfile << "Case #" << n + 1 << ": " << impossible << std::endl;
 		}
 		else
 		{
 			std::cout << "Case #" << n + 1 << ": " << result << std::endl;
 			outfile << "Case #" << n + 1 << ": " << result << std::endl;
 		}
 	}
 	infile.close();
 	outfile.close();
 	return 0;
 }
 
 
