#include <fstream>
 #include <vector>
 #include <string>
 #include <iostream>
 
 bool impossible(std::string row, int K) {
 	int counter = 0;
 	for (int i = 0; i < row.size(); i++) {
 		if (row[i] == '-') counter++;
 	}
 	return (counter % 2 != K % 2 && counter < K);
 }
 
 void flip(std::string& row, int pos, int K) {
 	for (int i = pos; i < pos + K; i++) {
 		if (row[i] == '-') row[i] = '+';
 		else if (row[i] == '+') row[i] = '-';
 	}
 }
 
 bool allHappySide(std::string row) {
 	for (int i = 0; i < row.size(); i++) {
 		if (row[i] == '-') return false;
 	}
 	return true;
 }
 
 int getNumOfFlips(std::string row, int K) {
 	if (allHappySide(row)) return 0;
 	if (impossible(row,K)) return -1;
 	int counter = 0;
 	int i = 0;
 	while (!allHappySide(row) && i <= row.size() - K) {
 		if (row[i] == '-') {
 			flip(row, i, K);
 			counter++;
 		}
 		i++;
 	}
 	return allHappySide(row) ? counter : -1;
 }
 
 int main() {
 	int T;
 	std::ifstream file_in("overprized_pancake_flipper.txt");
 	std::ofstream file_out("overprized_pancake_flipper_result.txt");
 	std::ofstream fout("check.txt");
 	file_in >> T;
 	for (int i = 0; i < T; i++) {
 		int K;
 		std::string pancakes_row;
 		file_in >> pancakes_row >> K;
 		file_out << "Case #" << i + 1 << ": ";
 		int result = getNumOfFlips(pancakes_row, K);
 		if (result == -1) file_out << "IMPOSSIBLE" << std::endl;
 		else file_out << result << std::endl;
 	}
 	return 0;
 }