#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 void flip(char *line, int start, int range){
   for (int i=start; i<start+range; i++) {
     if (line[i] == '+'){
       line[i] = '-';
     } else{
       line[i] = '+';
     }
   }
 }
 
 int easy_flip(char *line, int length, int range, int current)
 {
   int check = 0;
 
   if ((length - current) < range){
     return 0;
   }
 
   for (int i=current; i<current+range; i++){
     if (line[i] == '-'){
       check++;
     }
   }
   if (check == range){
     flip(line, current, range);
     return 1;
   }
   return 0;
 }
 
 int hard_flip(char *line, int length, int range, int current)
 {
   int c_minus = 0;
   int c_plus = 0;
   for (int i = current; i < length; i++) {
       if (line[i] == '+'){
         break;
       } else{
         c_minus++;
       }
   }
 
   int plus_init = current + c_minus;
   int needed = range - c_minus;
   //printf("pinit %d needed %d\n",plus_init,needed);
   if (needed >= range) return -1;
 
   for (int i = plus_init; i < length; i++) {
     if (line[i] == '-' || c_plus == needed){
       break;
     } else{
       c_plus++;
     }
   }
 
   if (c_plus == needed){
     flip(line, plus_init, range);
     flip(line, current, range);
     return 1;
   }else{
     return -1;
   }
 
 }
 
 int get_flips(char *line, int range)
 {
   int length = strlen(line);
   int flips = 0;
 
   for (int i=0; i<length; i++) {
     if (line[i] == '+') continue;
 
     int easy = easy_flip(line, length, range, i);
     if (easy == 1){
       flips++;
       i += range-1;
       continue;
     }
 
     int hard = hard_flip(line, length, range, i);
     if (hard == 1){
       flips += 2;
       i+=range-1;
       continue;
     } else{
       return -1;
     }
   }
 
   return flips;
 }
 
 int main()
 {
   int t_cases;
   scanf("%d\n",&t_cases);
 
   for (int i=0; i<t_cases; i++) {
     char string[1002];
     int flips, range;
     scanf("%s %d\n",string,&range);
     flips = get_flips(string, range);
 
     if (flips == -1){
       printf("Case #%d: IMPOSSIBLE\n",i+1);
     } else{
       printf("Case #%d: %d\n",i+1,flips);
     }
 
   }
 
   return 0;
 }
