/*	Un panqueque tiene una cara feliz y otra vacia
 	Tengo N panqueques enfilados
 	Puedo dar vuelta K panqueques a la vez
 	Decidir si puedo conseguir todos felices, y si se puede,
 	dar el mínimo de vueltas necesarias
 
 	Si tengo algún '-', lo tengo que dar vuelta
 
 	Proposición: Lo óptimo es dar vuelta el primer -, P
 
 	Si doy vuelta un I que está a la izquierda, como P es el primer
 	-, I va a ser + y va a quedar como -. Los voy a	tener que dar
 	vuelta. Si lo doy vuelta empezando de un R más a la izquierda,
 	la situación se repite. Si doy vuelta a partir del I, quedo
 	en la misma posición. Así que nunca conviene dar vuelta un I
 	a la izquierda de P.
 
 	Si doy vuelta un D que está a la derecha, sigo teniendo que
 	dar vuelta P. Si sigo haciendo combinaciones y vueltas con
 	panqueques a la derecha de P, P siendo -. Voy a tener que darlo
 	vuelta a partir de P en algún momento. Si llegué a una situación
 	óptima, desde un principio prodría haber dado vuelta P, luego
 	D, y luego las demás vueltas (el orden de vueltas no cambia
 	el resultado).
 
 	Listo, si no puedo dar vuelta el primer -, no hay algoritmo.
 	Si llego a un resultado correcto, hay.
 */
 
 #include <iostream>
 #include <string>
 
 using namespace std;
 
 int main() {
 	int t;
 	cin >> t;
 	
 	for (int c = 1; c <= t; c++) {
 		// Entrada
 		string s; cin >> s;
 		int k; cin >> k;
 
 		// Caso General
 		int turns = 0;
 		for (int i = 0; i <= s.size()-k; i++) {
 			if (s[i] == '-') {
 				turns++;
 				for (int j = i; j < i + k; j++) {
 					if (s[j] == '+') {
 						s[j] = '-';
 					} else {
 						s[j] = '+';
 					}
 				}
 			}
 		}
 
 		string res = to_string(turns);
 		for (int i = s.size()-k+1; i < s.size(); i++) {
 			if (s[i] == '-') {
 				res = "IMPOSSIBLE";
 				break;
 			}
 		}
 
 		// Salida
 		cout << "Case #" << c << ": " << res << endl;
 	}
 }