#include <iostream>
 #include <string>
 #include <vector>
 #include <algorithm>
 using namespace std;
 
 int successive(vector<int>& vstack, int K) {
 	int count = 0;
 	int current = 0;
 	for (int i = 0; i < static_cast<int>(vstack.size()); ++i) {
 		if (!current) { ++current; }
 		else if (vstack[i] == vstack[i - 1]) {
 			if (K == ++current) {
 				++count;
 				current = 1;
 			}
 		}
 		else {
 			current = 1;
 		}
 	}
 	return count;
 }
 
 bool allhappy(vector<int>& vstack) {
 	for (vector<int>::iterator it = vstack.begin(); it != vstack.end(); ++it) {
 		if (*it == -1) { return false; }
 	}
 	return true;
 }
 
 bool flip(vector<int>& vstack, int pos, int K, int initsuccessive) {
 	for (int attempt = 0; attempt < K; ++attempt) {
 		int start = pos - attempt;
 		if (start >= 0 && start + K - 1 < vstack.size()) {
 			vector<int> v = vstack;
 			bool positiveflip = true;
 			for (int i = 0; i < K; ++i) {
 				v[start + i] *= -1;
 				if (v[start + i] == -1) { positiveflip = false; }
 			}
 
 			if (positiveflip || allhappy(v) || initsuccessive < successive(v, K)) {
 				vstack = v;
 				return true;
 			}
 		}
 	}
 	return false;
 }
 
 int minFlips(vector<int>& vstack, int K) {
 	if (allhappy(vstack)) { return 0; }
 	int initsuccessive = successive(vstack, K);
 	for (int i = 0; i < static_cast<int>(vstack.size()); ++i) {
 		if (vstack[i] == -1 && flip(vstack, i, K, initsuccessive)) {
 			return 1 + minFlips(vstack, K);
 		}
 	}
 	return -255;
 }
 
 int minFlips(string stack, int K) {
 	vector<int> vstack;
 	for (int i = 0; i < stack.size(); ++i) {
 		vstack.push_back(((stack[i] == '+') ? 1 : -1));
 	}
 	return minFlips(vstack, K);
 }
 
 int main(int argc, char const *argv[])
 {
 	int T;
 	cin >> T;
 	string stack;
 	int K;
 	for (int c = 0; c < T; ++c) {
 		cin >> stack;
 		cin >> K;
 		int flips = minFlips(stack, K);
 		if (flips < 0) {
 			cout << "Case #" << c + 1 << ": IMPOSSIBLE" << endl;
 		}
 		else {
 			cout << "Case #" << c + 1 << ": " << flips << endl;
 		}
 	}
 	return 0;
 }