#include <errno.h>
 #include <stdio.h>
 #include <stdint.h>
 #include <stdlib.h>
 
 
 int main(int argc, char **argv) {
   char buffer[BUFSIZ];
   uint32_t records, i;
   FILE *src = stdin, *dst = stdout;
   struct { uint32_t remain, time; } barbers[1000];
 
   if(argc >= 2) {
     src = fopen(argv[1], "rb");
   }
 
   if(argc >= 3) {
     dst = fopen(argv[2], "wb");
   }
 
   if(!fgets(&buffer[0], sizeof(buffer), src)) {
     return 1;
   }
 
   if(sscanf(&buffer[0], "%u", &records) != 1) {
      return 2;
   }
 
   for(i = 0; i < records; i++) {
     char *ptr = &buffer[0], *end;
     uint32_t j, count, customers, min, tmp, cycle_length;
     uint64_t cycle;
 
     if(!fgets(ptr, sizeof(buffer), src)) {
       return 3;
     }
 
     if(sscanf(&buffer[0], "%u %u", &count, &customers) != 2) {
        return 4;
     }
 
     if(!fgets(ptr, sizeof(buffer), src)) {
       return 5;
     }
 
     for(cycle = 1, j = 0; j < count; j++, ptr = &end[1]) {
       barbers[j].remain = 0;
       barbers[j].time = strtoul(ptr, &end, 10);
       if(cycle % barbers[j].time) {
         cycle *= barbers[j].time;
       }
 
       if(*end != ' ' && *end != '\n' && *end != '\0') {
          return 4;
       }
     }
     
     for(cycle_length = j = 0; j < count; j++) {
       cycle_length += (uint32_t) (cycle / barbers[j].time);
     }
 
     customers -= count;
 
     if(!(customers %= cycle_length)) {
       fprintf(dst, "Case #%u: %u\n", i + 1, count);
       continue;
     }
 
     while(1) {
       uint32_t k;
 
       for(tmp = 0xFFFFFFFF, k = 0; k < count; k++) {
         if(!(barbers[k].remain -= min)) {
           barbers[k].remain = barbers[k].time;
           if(!--customers) {
             fprintf(dst, "Case #%u: %u\n", i + 1, k + 1);
             goto exit_loop;
           }
         }
         if(tmp > barbers[k].remain) {
           tmp = barbers[k].remain;
         }
       }
 
       min = tmp;
     }
 exit_loop:
     continue;
   }
 }
 
