#pragma comment(linker, "/STACK:16777216")
 #include <iostream>
 #include <climits>
 #include <fstream>
 #include <cstring>
 #include <cmath>
 #include <vector>
 #include <set>
 #include <map>
 #include <algorithm>
 #include <iomanip>
 #include <cstdio>
 #include <ctime>
 #include <functional>
 #include <iterator>
 #include <complex>
 #include <queue>
 #include <cassert>
 #include <sstream>
 #include <cstdlib>
 
 #define PROBLEM_ID ""
 
 using namespace std;
 
 double pi = acos((double) -1);
 const int MOD = 1000000007;
 const int INF = 2147483647;
 const double EPS = 1e-9;
 const long long LLONG_INF = 9223372036854775807LL;
 
 template<typename T>
 void print(vector<T>& a) {
     for (int i = 0; i < a.size(); i++)
         cout << a[i] << " ";
     cout << endl;
 }
 
 struct barber {
     int time, order;
 };
 
 vector<long long> get_total_processed_clients_picture(int i1, int b, vector<barber>& barbers, long long& total) {
     vector<long long> res(b);
     res[0] = i1;
     total = res[0];
     for (int i = 1; i < barbers.size(); i++) {
         res[i] = i1 * 1ll * barbers[0].time / barbers[i].time;
         if (i1 * 1ll * barbers[0].time % barbers[i].time != 0)
             res[i]++;
         total += res[i];
     }
     return res;
 }
 
 int main() {
     ios_base::sync_with_stdio(0);
     clock_t tStart = clock();
     //freopen(PROBLEM_ID".in", "r", stdin);
     //freopen(PROBLEM_ID".out", "w", stdout);
     int tests;
     cin >> tests;
     for (int test = 1; test <= tests; test++) {
         int b, n;
         cin >> b >> n;
         vector<barber> barbers;
         int maxtime = 0;
         for (int i = 0; i < b; i++) {
             int time;
             cin >> time;
             barbers.push_back(barber{time, i});
             maxtime = max(maxtime, time);
         }
 
         if (n <= b) {
             cout << "Case #" << test << ": " << n << endl;
             continue;
         }
 
         int lo = 0, hi = n - 1, mid;
         long long total;
         while (lo <= hi) {
             mid = lo + (hi - lo) / 2; // number of clients the first barber has processed
             auto clients_picture = get_total_processed_clients_picture(mid, b, barbers, total);
             if (n - 1 < total) {
                 hi = mid - 1;
             }
             else if (n - 1 > total) {
                 lo = mid + 1;
             }
             else {
                 break;
             }
         }
 
         while (true) {
             auto clients_picture = get_total_processed_clients_picture(mid, b, barbers, total);
             if (total > n - 1) {
                 mid--;
             }
             else {
                 break;
             }
         }
 
         int time = mid * barbers[0].time;
         bool started = false, found = false;
         int answer = 0;
         while (total < n - 1 && !found) {
             for (int i = 0; i < b; i++) {
                 if (started && time % barbers[i].time == 0) {
                     total++;
                     if (total == n - 1) {
                         answer = i;
                         found = true;
                         break;
                     }
                 }
                 started = true;
             }
             time++;
         }
 
         cout << "Case #" << test << ": " << answer + 1 << endl;
     }
     //printf("Time taken: %.2fs\n", (double)(clock() - tStart)/CLOCKS_PER_SEC);
 }
