#include <iostream>
 #include <vector>
 #include <queue>
 #include <stdlib.h>
 #include <algorithm>
 #include <math.h>
 
 using namespace std;
 
 typedef struct __pt {
 	int x,y;
 } Point;
 
 vector<Point> pts, out;
 
 int counterclockwise(int a, int b, int c) {
 	long int area = (long int)pts[a].x*pts[b].y - (long int)pts[a].y*pts[b].x + (long int)pts[a].y*pts[c].x - (long int)pts[a].x*pts[c].y + (long int)pts[b].x*pts[c].y - (long int)pts[b].y*pts[c].x;
 	return (area > 0 ? 1 : 0);
 }
 
 int triangle(int a, int b, int c, int d, int *p1, int *p2, int *p3) {
 	int A, B;
 	long int alfa1, alfa2, alfa3, dist, dtmp, xtmp, ytmp;
 
 	*p1=*p2=*p3=-1;
 	dist = 0;
 	for(int i=0; i < 3; i++) {
 		switch(i) {
 			case 0:
 				A = a;
 				break;
 			case 1:
 				A = b;
 				break;
 			case 2:
 				A = c;
 		}
 		for(int j=i+1; j < 4; j++) {
 			switch(j) {
 				case 1:
 					B = b;
 					break;
 				case 2:
 					B = c;
 					break;
 				case 3:
 					B = d;
 			}
 			if(A != B) {
 				xtmp = pts[A].x-pts[B].x;
 				ytmp = pts[A].y-pts[B].y;
 				dtmp = xtmp*xtmp+ytmp*ytmp;
 				if(dtmp > dist) {
 					dist = dtmp;
 					*p1 = A;
 					*p2 = B;
 				}
 			}
 		}
 	}
 
 	alfa1 = pts[*p2].y-pts[*p1].y;
 	alfa2 = pts[*p2].x-pts[*p1].x;
 	alfa3 = alfa2*pts[*p1].y-alfa1*pts[*p1].x;
 
 	if(a != *p1 && a != *p2 && labs(alfa1*pts[a].x-alfa2*pts[a].y+alfa3) > 0)
 		*p3 = a;
 	else if(b != *p1 && b != *p2 && labs(alfa1*pts[b].x-alfa2*pts[b].y+alfa3) > 0)
 		*p3 = b;
 	else if(c != *p1 && c != *p2 && labs(alfa1*pts[c].x-alfa2*pts[c].y+alfa3) > 0)
 		*p3 = c;
 	else if(d != *p1 && d != *p2 && labs(alfa1*pts[d].x-alfa2*pts[d].y+alfa3) > 0)
 		*p3 = d;
 	else {
 		dist = 0;
 		for(int i=0; i < pts.size(); i++) {
 			dtmp = labs(alfa1*pts[i].x-alfa2*pts[i].y+alfa3);
 			if(dtmp > dist) {
 				dist =  dtmp;
 					*p3 = i;
 			}
 		}
 	}
 
 	if(!counterclockwise(*p1, *p2, *p3)) {
 		A = *p2;
 		*p2 = *p3;
 		*p3 = A;
 	}
 }
 
 bool sortPoint(Point i, Point j) {
 	return (i.x < j.x ? true : (i.x == j.x && i.y < j.y ? true : false));
 }
 
 int main() {
 	int tt, tt1, n, minX, maxX, minY, maxY, *hull, a, b, c, m[3];
 	Point pt;
 	queue< vector<int> > vertex;
 	queue<int> edge[3];
 	vector<int> l[3], t[3];
 	long long int alfa1[3], alfa2[3], alfa3[3], dist[3], dtmp;
 
 cin >> tt1;
 tt=0;
 for(tt=0; tt < tt1; tt++) {
 	cin >> n;
 	cin >> pt.x >> pt.y;
 	pts.clear();
 	pts.push_back(pt);
 	minX=maxX=minY=maxY=0;
 	for(int i=1; i < n; i++) {
 		cin >> pt.x >> pt.y;
 		pts.push_back(pt);
 
 		if(pt.x > pts[maxX].x)
 			maxX = i;
 		else if(pt.x < pts[minX].x)
 			minX = i;
 		if(pt.y > pts[maxY].y)
 			maxY = i;
 		else if(pt.y < pts[minY].y)
 			minY = i;
 	}
 
 	if(pts.size() <= 3 || maxX-minX == 0 || maxY-minY == 0) {
 			cout << "Case #" << tt+1 << ":" << endl;
 			for(int i=0; i < pts.size(); i++)
 				cout << "0" << endl;
 			continue;
 	}
 
 //	for(int i=0; i < n; i++)
 //		cout << pts[i].x << " " << pts[i].y << endl;
 //	cout << endl;
 
 	hull = new int[pts.size()];
 	for(int i=0; i < pts.size(); i++)
 		hull[i] = 0;
 	triangle(minX, maxX, minY, maxY, &a, &b, &c);
 	hull[a] = hull[b] = hull[c] = 1;
 
 	for(int i=0; i < 3; i++) {
 		l[i].clear();
 		t[i].clear();
 		m[i] = -1;
 		dist[i] = 0;
 	}
 
 	alfa1[0] = pts[b].y-pts[a].y;
 	alfa2[0] = pts[b].x-pts[a].x;
 	alfa3[0] = alfa2[0]*pts[a].y-alfa1[0]*pts[a].x;
 
 	alfa1[1] = pts[c].y-pts[b].y;
 	alfa2[1] = pts[c].x-pts[b].x;
 	alfa3[1] = alfa2[1]*pts[b].y-alfa1[1]*pts[b].x;
 
 	alfa1[2] = pts[a].y-pts[c].y;
 	alfa2[2] = pts[a].x-pts[c].x;
 	alfa3[2] = alfa2[2]*pts[c].y-alfa1[2]*pts[c].x;
 //cout << "ha" << endl;
 	for(int i=0; i < pts.size(); i++) {
 //	cout << i << endl;
 		for(int j=0; j < 3; j++) {
 			dtmp = alfa1[j]*(long long int)pts[i].x-alfa2[j]*(long long int)pts[i].y+alfa3[j];
 //	cout << dtmp << endl;
 			if(dtmp > dist[j]) {
 				dist[j] = dtmp;
 				m[j] = i;
 			}
 //cout << "hein " << j << endl;
 			if(dtmp > 0) {
 //				cout << ":/" << endl;
 				l[j].push_back(i);
 			}
 			else if(dtmp == 0) {
 //				cout << ":(" << endl;
 				t[j].push_back(i);
 			}
 //cout << "hein2 " << j << endl;
 		}
 //	cout << endl;
 	}
 //cout << "ha" << endl;
 	for(int i=0; i < 3; i++) {
 		if(!l[i].empty()) {
 			hull[m[i]] = 1;
 			edge[0].push((i==0 ? a : (i==1 ? b : c)));
 			edge[1].push(m[i]);
 			edge[2].push((i==0 ? b : (i==1 ? c : a)));
 			vertex.push(l[i]);
 		}
 		else {
 			for(int j=0; j < t[i].size(); j++)
 				hull[t[i][j]] = 1;
 		}
 	}
 //cout << "ha" << endl;
 	while(!vertex.empty()) {
 		for(int i=0; i < 3; i++) {
 			l[i].clear();
 			t[i].clear();
 			m[i] = -1;
 			dist[i] = 0;
 		}
 		l[2] = vertex.front();
 		vertex.pop();
 		a = edge[0].front();
 		edge[0].pop();
 		b = edge[1].front();
 		edge[1].pop();
 		c = edge[2].front();
 		edge[2].pop();
 
 		alfa1[0] = pts[b].y-pts[a].y;
 		alfa2[0] = pts[b].x-pts[a].x;
 		alfa3[0] = alfa2[0]*pts[a].y-alfa1[0]*pts[a].x;
 
 		alfa1[1] = pts[c].y-pts[b].y;
 		alfa2[1] = pts[c].x-pts[b].x;
 		alfa3[1] = alfa2[1]*pts[b].y-alfa1[1]*pts[b].x;
 
 		for(int i=0; i < l[2].size(); i++) {
 			for(int j=0; j < 2; j++) {
 				dtmp = alfa1[j]*pts[l[2][i]].x-alfa2[j]*pts[l[2][i]].y+alfa3[j];
 				if(dtmp > dist[j]) {
 					dist[j] = dtmp;
 					m[j] = l[2][i];
 				}
 
 				if(dtmp > 0)
 					l[j].push_back(l[2][i]);
 				else if(dtmp == 0)
 					t[j].push_back(l[2][i]);
 			}
 		}
 
 		for(int i=0; i < 2; i++) {
 			if(!l[i].empty()) {
 				hull[m[i]] = 1;
 				edge[0].push((i==0 ? a : b));
 				edge[1].push(m[i]);
 				edge[2].push((i==0 ? b : c));
 				vertex.push(l[i]);
 			}
 			else {
 				for(int j=0; j < t[i].size(); j++)
 					hull[t[i][j]] = 1;
 			}
 		}
 	}
 //cout << "ha" << endl;
 	double avgx=0, avgy=0;
 	out.clear();
 	for(int i=0; i < pts.size(); i++)
 		if(hull[i]) {
 			out.push_back(pts[i]);
 			avgx += pts[i].x;
 			avgy += pts[i].y;
 		}
 	avgx /= out.size();
 	avgy /= out.size();
 
 	if(pts.size() == out.size()) {
 			//cout << "ha" << endl;
 			cout << "Case #" << tt+1 << ":" << endl;
 			for(int i=0; i < pts.size(); i++)
 				cout << "0" << endl;
 			continue;
 	}
 
 	double angle[out.size()];
 	for(int i=0; i < out.size(); i++)
 		angle[i] = atan2(out[i].x-avgx, out[i].y-avgy);
 	for(int i=0; i < out.size(); i++)
 		for(int j=i; j < out.size(); j++)
 			if(angle[j] < angle[i]) {
 				double tmpa = angle[i];
 				angle[i] = angle[j];
 				angle[j] = tmpa;
 				Point tmpp = out[i];
 				out[i] = out[j];
 				out[j] = tmpp;
 			}
 
 	int count1[out.size()], count2[out.size()];
 //	for(int i=0; i < n; i++)
 //		cout << pts[i].x << " " << pts[i].y << endl;
 //	cout << endl;
 	cout << "Case #" << tt+1 << ":" << endl;
 	for(int i=0; i < pts.size(); i++) {
 		if(hull[i]) {
 			cout << "0" << endl;
 		}
 		else {
 			for(int j=0; j < out.size(); j++) {
 				count1[j] = count2[j] = 0;
 				angle[j] = atan2(out[j].x-pts[i].x, out[j].y-pts[i].y);
 			}
 			for(int j=0; j < pts.size(); j++) {
 				if(i!=j) {
 					double a = atan2(pts[j].x-pts[i].x, pts[j].y-pts[i].y);
 					int esq=0, dir=out.size()-1, meio;
 					while(esq <= dir) {
 						meio = (esq+dir)/2;
 						if(a == angle[meio])
 							break;
 						else if(a < angle[meio])
 							dir = meio-1;
 						else
 							esq = meio+1;
 					}
 					if(a==angle[meio])
 						count1[meio]++;
 					else
 						count2[esq%out.size()]++;
 				}
 			}
 
 			const double pi = 3.14159265359;
 
 			int k=1, max=0;
 			for(int j=0; j < out.size(); j++) {
 				while(k!=j && (k > j && angle[k]-angle[j] <= pi || k < j && pi+angle[k]+pi-angle[j] <= pi))
 					k=(k+1)%out.size();
 				//cout << j << " " << k << " LLLLL"<< endl;
 				int l=j, sum=count1[l];
 				while(l != k) {
 					l=(l+1)%out.size();
 					sum += count1[l]+count2[l];
 				}
 				if(sum > max)
 					max = sum;
 			}
 
 			cout << pts.size()-max << endl;
 
 			//for(int j=0; j < out.size(); j++)
 			//	cout << count1[j] << " ";
 			//cout << endl;
 
 			//for(int j=0; j < out.size(); j++)
 			//	cout << count2[j] << " ";
 			//cout << endl;
 
 			//for(int j=0; j < out.size(); j++)
 			//	cout << angle[j] << " ";
 			//cout << endl;
 		}
 	}
 
 //	sort(out.begin(), out.end(), sortPoint);
 //	for(int i=0; i < out.size(); i++)
 //		cout << out[i].x << " " << out[i].y << endl;
 //	cout << endl;
 }
 }
 
