#include <stdio.h>
 #include <ctype.h>
 #include <string.h>
 #include <stdlib.h>
 #include <limits.h>
 #include <math.h>
 #include <algorithm>
 using namespace std;
 
 int T,n,cas=1;
 
 struct Point
 {
 	double x,y;
 	int id;
 	Point(double px=0.0,double py=0.0):x(px),y(py){}
 	bool operator==(const Point & b)const{
 		return fabs(x-b.x)<1e-9&&fabs(y-b.y)<1e-9;
 	}
 	Point operator-(Point b){
 		return Point(x-b.x,y-b.y);
 	}
 	Point operator+(Point b){
 		return Point(x+b.x,y+b.y);
 	}
 	Point operator*(double k){
 		return Point(x*k,y*k);
 	}
 }point[3005];
 int ans[3005];
 
 double dis(Point a,Point b)
 {
 	return sqrt((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y));
 }
 
 double cross(Point a,Point b)
 {
 	return a.x*b.y-a.y*b.x;
 }
 
 struct Line
 {
 	Point a,b;
 	Line(){}
 	Line(Point pa,Point pb):a(pa),b(pb){}
 	bool hasCommonPoint(const Line &lb){
 		return a==lb.a||a==lb.b||b==lb.a||b==lb.b;
 	}
 	double distanceToPoint(Point p)
 	{
 		if(a==b) return dis(p,a);
 		Point v1=b-a,v2=p-a,v3=p-b;
 		if(v1.x*v2.x+v1.y*v2.y<-1e-9) return sqrt(v2.x*v2.x+v2.y*v2.y);
 		else if (v1.x*v3.x+v1.y*v3.y>1e-9) return sqrt(v3.x*v3.x+v3.y*v3.y);
 		else return fabs(cross(v1,v2))/sqrt(v1.x*v1.x+v1.y*v1.y);
 	}
 	Point getCrossPoint(Line lb)
 	{
 		Point u=a-lb.a;
 		Point v=b-a;
 		Point w=lb.b-lb.a;
 		double t=cross(w,u)/cross(v,w);
 		return a+v*t;
 	}
 };
 
 int stack[3005];
 int stacktop;
 
 Point getvector(Point a,Point b)
 {
 	Point c;
 	c.x=a.x-b.x;
 	c.y=a.y-b.y;
 	return c;
 }
 
 int cmp1(const Point a,const Point b)
 {
 	if (a.y==b.y) return a.x<b.x;
 	return a.y<b.y;
 }
 
 
 int cmp(const Point a,const Point b)
 {
 	if (fabs(cross(getvector(a,point[0]),getvector(b,point[0])))<1e-8)
 		return dis(point[0],a)<dis(point[0],b);
 	return cross(getvector(a,point[0]),getvector(b,point[0]))>0;
 }
 
 Point p2[10005];
 
 bool test(int n,int pid,Point point[]){
 	stack[0]=0;
 	stack[1]=1;
 	stack[2]=2;
 	stacktop=2;
 	for(int i=3;i<n;i++)
 	{
 		while(cross(getvector(point[stack[stacktop-1]],point[stack[stacktop]]),getvector(point[stack[stacktop-1]],point[i]))<0){
 			if(point[stack[stacktop]].id==pid){
 				return false;
 			}
 			stacktop--;
 		}
 		stacktop++;
 		stack[stacktop]=i;
 	}
 	while(cross(getvector(point[stack[stacktop-1]],point[stack[stacktop]]),getvector(point[stack[stacktop-1]],point[0]))<0){
 		if(point[stack[stacktop]].id==pid){
 			return false;
 		}
 		stacktop--;
 	}
 	return true;
 }
 
 int bestsit;
 void dfs(int save,int inque,int last){
 	if(last==n){
 		if(inque<3)return;
 		sort(p2,p2+n,cmp1);
 		sort(p2+1,p2+n,cmp);
 		if(test(inque,save,p2)){
 			bestsit=max(bestsit,inque);
 		}
 		return;
 	}
 	if(point[last].id==save){
 		p2[inque]=point[last];
 		dfs(save,inque+1,last+1);
 	}else{
 		p2[inque]=point[last];
 		dfs(save,inque+1,last+1);
 		
 		dfs(save,inque,last+1);
 	}
 }
 
 int main()
 {
 	freopen("C-small-attempt2.in","r",stdin);
 	freopen("cout5.txt","w",stdout);
 	for(scanf("%d",&T);cas<=T;)
 	{
 		scanf("%d",&n);
 		for(int i=0;i<n;i++){
 			scanf("%lf%lf",&point[i].x,&point[i].y);
 			point[i].id=i;
 		}
 		sort(point,point+n,cmp1);
 		sort(point+1,point+n,cmp);
 		memset(stack,0,sizeof(stack));
 		stack[0]=0;
 		stack[1]=1;
 		stack[2]=2;
 		stacktop=2;
 		for(int i=3;i<n;i++)
 		{
 			while(cross(getvector(point[stack[stacktop-1]],point[stack[stacktop]]),getvector(point[stack[stacktop-1]],point[i]))<-1e-9)
 				stacktop--;
 			stacktop++;
 			stack[stacktop]=i;
 		}
 		while(cross(getvector(point[stack[stacktop-1]],point[stack[stacktop]]),getvector(point[stack[stacktop-1]],point[0]))<-1e-9)
 			stacktop--;
 		stacktop++;
 		stack[stacktop]=0;
 
 		memset(ans,0,sizeof(ans));
 		for(int i=0;i<stacktop;i++)
 			ans[point[stack[i]].id]=-1;
 			
 		for(int i=0;i<n;i++){
 			if(ans[point[i].id]==-1)continue;
 			
 			for(int p=0;p<stacktop;p++){
 				Line tmp(point[stack[p]],point[stack[p+1]]);
 				if(tmp.distanceToPoint(point[i])<1e-9){
 					ans[point[i].id]=-1;
 					break;
 				}
 			}
 		}
 			
 		for(int pid=0;pid<n;pid++){
 			if(ans[pid]==-1)continue;
 			bestsit=0;
 			dfs(pid,0,0);
 			ans[pid]=n-bestsit;
 		}
 		printf("Case #%d:\n",cas++);
 		for(int i=0;i<n;i++){
 			printf("%d\n",ans[i]<0?0:ans[i]);
 		}
 		fflush(stdout);
 	}
 	return 0;
 }
 
