#include <cstdio>
 #include <vector>
 #include <map>
 #include <algorithm>
 
 using namespace std;
 
 int n;
 vector<pair<long long,long long> > pts;
 vector< int > res;
 map<pair<long long,long long>,int> idx;
 
 long long prodscal(pair<long long,long long> i,pair<long long,long long> j){
   return i.first*j.first+i.second*j.second;
 }
 
 pair<long long, long long> cur_vec;
 
 bool sort_f (pair<long long,long long> i,pair<long long,long long> j) {
   return prodscal(i,cur_vec)<prodscal(j,cur_vec); 
 }
 
 void sweep(int i, int j){
   vector<pair<long long,long long> > pts2(pts);
   cur_vec=make_pair(pts[i].second-pts[j].second,pts[j].first-pts[i].first);
   std::sort(pts2.begin(),pts2.end(),sort_f);
   int ii=0;
   long long ps=prodscal(pts[i],cur_vec);
   while(prodscal(pts2[ii],cur_vec)<ps)ii++;
   int ii2=n-1;
   while(prodscal(pts2[ii2],cur_vec)>ps){ii2--;}
   
   res[i]=min(res[i],ii);
   res[i]=min(res[i],n-1-ii2);
   res[j]=min(res[j],ii);
   res[j]=min(res[j],n-1-ii2);
 }
 
 
 
 int main(){
   int t;
   scanf("%d", &t);
   for(int cas=1;cas<=t;cas++){
     scanf("%d", &n);
     pts.clear();
     idx.clear();
     res.clear();
     res.resize(n,n);
     for(int i=0;i<n;i++){
       int x, y;
       scanf("%d %d",&x,&y);
       pts.push_back(make_pair((long long)x,(long long)y));
     }
     for(int cur_i=0;cur_i<n;cur_i++){
       for(int cur_j=0;cur_j<n;cur_j++){
         if(cur_i==cur_j)continue;
         sweep(cur_i,cur_j);
       }
     }
     printf("Case #%d:\n",cas);
     for(int ii=0;ii<n;ii++)
       printf("%d\n",res[ii]);
   }
 }
