#include <stdio.h> 
 #include <math.h>
 #include <algorithm>
 #include <set>
 #include <assert.h>
 #include <vector>
 using namespace std;
 #define eps 1e-8
 struct Pt {
     double x, y;
     Pt(double a = 0, double b = 0):
     	x(a), y(b) {}	
 	Pt operator-(const Pt &a) const {
         return Pt(x - a.x, y - a.y);
     }
     Pt operator+(const Pt &a) const {
         return Pt(x + a.x, y + a.y);
     }
     Pt operator*(const double a) const {
         return Pt(x * a, y * a);
     }
     bool operator==(const Pt &a) const {
     	return fabs(x - a.x) < eps && fabs(y - a.y) < eps;
 	}
     bool operator<(const Pt &a) const {
 		if (fabs(x - a.x) > eps)
 			return x < a.x;
 		if (fabs(y - a.y) > eps)
 			return y < a.y;
 		return false;
 	}
 	double length() {
 		return hypot(x, y);
 	}
 	void read() {
 		scanf("%lf %lf", &x, &y);
 	}
 };
 double dot(Pt a, Pt b) {
 	return a.x * b.x + a.y * b.y;
 }
 double cross(Pt o, Pt a, Pt b) {
     return (a.x-o.x)*(b.y-o.y)-(a.y-o.y)*(b.x-o.x);
 }
 double cross2(Pt a, Pt b) {
     return a.x * b.y - a.y * b.x;
 }
 int between(Pt a, Pt b, Pt c) {
 	return dot(c - a, b - a) >= -eps && dot(c - b, a - b) >= -eps;
 }
 int onSeg(Pt a, Pt b, Pt c) {
 	return between(a, b, c) && fabs(cross(a, b, c)) < eps;
 }
 struct Seg {
 	Pt s, e;
 	double angle;
 	int label;
 	Seg(Pt a = Pt(), Pt b = Pt(), int l=0):s(a), e(b), label(l) {
 //		angle = atan2(e.y - s.y, e.x - s.x);
 	}
 	bool operator<(const Seg &other) const {
 		if (fabs(angle - other.angle) > eps)
 			return angle > other.angle;
 		if (cross(other.s, other.e, s) > -eps)
 			return true;
 		return false;
 	}
 	bool operator!=(const Seg &other) const {
 		return !((s == other.s && e == other.e) || (e == other.s && s == other.e));
 	}
 };
 Pt getIntersect(Seg a, Seg b) {
 	Pt u = a.s - b.s;
     double t = cross2(b.e - b.s, u)/cross2(a.e - a.s, b.e - b.s);
     return a.s + (a.e - a.s) * t;
 }
 double getAngle(Pt va, Pt vb) { // segment, not vector
 	return acos(dot(va, vb) / va.length() / vb.length());
 }
 Pt rotateRadian(Pt a, double radian) {
 	double x, y;
 	x = a.x * cos(radian) - a.y * sin(radian);
 	y = a.x * sin(radian) + a.y * cos(radian);
 	return Pt(x, y);
 }
 const double pi = acos(-1);
 int cmpZero(double v) {
 	if (fabs(v) > eps) return v > 0 ? 1 : -1;
 	return 0;
 }
 int monotone(int n, Pt p[], Pt ch[]) {
     sort(p, p+n);
     int i, m = 0, t;
     for(i = 0; i < n; i++) {
         while(m >= 2 && cross(ch[m-2], ch[m-1], p[i]) <= 0)
             m--;
         ch[m++] = p[i];
     }
     for(i = n-1, t = m+1; i >= 0; i--) {
         while(m >= t && cross(ch[m-2], ch[m-1], p[i]) <= 0)
             m--;
         ch[m++] = p[i];
     }
     return m-1;
 }
 int main() {
 	int testcase, cases = 0;
 	int n;
 	scanf("%d", &testcase);
 	while (testcase--) {
 		scanf("%d", &n);
 		Pt P[1024];
 		for (int i = 0; i < n; i++)
 			scanf("%lf %lf", &P[i].x, &P[i].y);
 		
 		int ret[16] = {};
 		for (int i = 0; i < n; i++)
 			ret[i] = n;
 		for (int i = 0; i < (1<<n); i++) {
 			int m = 0, cnt = 0;
 			Pt a[32], ch[32];
 			for (int j = 0; j < n; j++) {
 				if ((i>>j)&1)
 					a[m++] = P[j];
 			}
 			
 			int cn = monotone(m, a, ch);
 			for (int p = 0; p < n; p++) {
 				if ((i>>p)&1)
 				for (int j = 0, k = cn-1; j < cn; k = j++) {
 					if (onSeg(ch[j], ch[k], P[p])) {
 						ret[p] = min(ret[p], n - m);
 					}
 				}
 			}
 		}
 		printf("Case #%d:\n", ++cases);
 		for (int i = 0; i < n; i++)
 			printf("%d\n", ret[i]);
 	}
 	return 0;
 }
