import numpy as np
import pandas as pd
from os import path




def dist_tracker(dist_hist, new, name):
	#dist_hist: the history of the activations
	#new: the new raw activations to add to dist_hist
	#name: name of the model
	#returns: updated dist_hist with new percentiles
	#ALSO: saves dist_hist to a csv
	#print(new)
	new = np.mean(new, axis=0) #Take avg across batches

	first_q = np.percentile(new, q=15)
	second_q = np.percentile(new, q=50)
	third_q = np.percentile(new, q=85)

	dist_hist.append([first_q, second_q, third_q]) 

	keys = [f"{name}_15", f"{name}_50", f"{name}_85"]

	save_dist_history(keys=keys, values=dist_hist)



def save_dist_history(keys, values):
	#Keys and values are lists
	file = "enn_photos\\dist_history.csv"
	display_step = 500 #Function caller must adhere to this
	max_step = 1000000 #Just needs to be large
	if path.exists(file): #Load csv

		df_load = pd.read_csv(file, index_col=0)
		for key in keys:
			df_load[key] = np.nan

	else: #New CSV
		print("~~ CREATING HISTORY CSV ~~") 
		index = range(display_step, max_step+display_step, display_step)
		df_load = pd.DataFrame(np.nan, columns=keys, index=index)

	for i in range(len(keys)):
		df_load[keys[i]].loc[:len(values)*display_step] = list(zip(*values))[i] #Set CSV column to the ith column from the list of lists

	#Save
	try:
		df_load.to_csv(file)
	except:
		print("CSV not updated")

		

