#!/bin/bash

set -x
# Exit script when a command returns nonzero state
set -e

set -o pipefail

export PYTHONUNBUFFERED="True"
export CUDA_VISIBLE_DEVICES=$1

export BATCH_SIZE=${BATCH_SIZE:-9}
export DATASET=${DATASET:-SynthiaCVPR15cmVoxelizationDataset}
export MODEL=${MODEL:-Res16UNet14A}

export TIME=$(date +"%Y-%m-%d_%H-%M-%S")

export LOG_DIR=./outputs/Synthia4D$2/$TIME

# Save the experiment detail and dir to the common log file
mkdir -p $LOG_DIR

LOG="$LOG_DIR/$TIME.txt"

python -m main \
    --log_dir $LOG_DIR \
    --dataset $DATASET \
    --model $MODEL \
    --lr 1e-1 \
    --batch_size $BATCH_SIZE \
    --scheduler PolyLR \
    --max_iter 120000 \
    --train_limit_numpoints 1200000 \
    --train_phase train \
    $3 2>&1 | tee -a "$LOG"

python -m main \
    --log_dir $LOG_DIR \
    --dataset $DATASET \
    --model $MODEL \
    --is_train False \
    --weights $LOG_DIR/weights.pth \
    $3 2>&1 | tee -a "$LOG"
