close all; clear all; clc;

% ===== General parameters =====
m = 100;            % Ambient dimension
n = 100;            % Number of samples
K = 4;              % Number of clusters
r = 1;              % Subspaces dimension
s = 1e-3;           % Noise level


% ===== Choice of clustering (both are essentially the same anyway) =====
% No permutation (easier to visualize)
permutation = 1:n;
% Optional permutation (as real data would look)
%permutation = randperm(n)';

% ===== Generate data =====
U = [];                   % Subspaces (centers)
V = [];         % Coefficients/clustering matrix
Omega = zeros(n,1);         % Clustering sets
for k=1:K
    Uk = abs(randn(m,r)); % ONMF
    %Uk = randn(m,r); % Kmeans

    range = floor((k-1)*n/K)+1:floor(k*n/K);
    Omega(permutation(range)) = k;

    Vk = zeros(n,r);
    Vk(permutation(range),:) = abs(randn(length(range),r)); %ONMF
    %Vk(permutation(range),:) = ones(length(range),r); %Kmeans

    U = [U Uk];
    V = [V Vk];
end

% True data
Y = U*V';

% Add noise
Z = s*randn(m,n);
X = Y + Z;

% ===== Do closed form =====
[~,~,Vhat] = svd(X);
Vhat = Vhat(:,1:min(n,K*r));
Phat = Vhat*Vhat';
OmegaHat = SpectralClustering(abs(Phat),K);
OmegaHat = bestMap(Omega,OmegaHat);
err = mean(Omega~=OmegaHat)




