function[W,H,loss] = SMF(X,k,wse,lamda1,lamda2,alpha)
%%INPUTS
%X is the interaction data, k is low rank factorization value
%lamda1 and lamda2 are the regularization weigths for l1 and l2
%regularization
%alpha is the importance of the zeros during the learning

%%OUTPUTS
%W and H are the non-negative matrices such that X ~ WH
%loss is a vector containing the value of the loss for each iteration of
%the optimization process
[n,m] = size(X);
sqrteps = sqrt(eps);

X = gpuArray(X);
W0 = gpuArray(0.1*rand(n,k));
H0 = gpuArray(0.1*rand(k,m));
H0 = H0./repmat(sqrt(sum(H0.^2,2)),1,m);

Ix = gpuArray(eye(n));

P = zeros(n,m) + alpha;
P(X>0) = 1;
P = gpuArray(P);

X1 = (((P.^2).*(X))*(X')).*Ix;
X2 = (P.^2).*(X);

loss = 0.5*norm(P.*(X-W0*H0),'fro')^2 + 0.25*wse*norm(P.*(X - (Ix.*(W0*W0'))*X),'fro')^2 + 0.5*lamda2*norm(H0,'fro')^2 + 0.5*lamda2*norm(W0,'fro')^2 + lamda1*norm(W0,1) + lamda1*norm(H0,1);
i = 1;
delta = 1;

while (delta>1e-3 && i<20000) | 
    
    T0 = W0*W0';
    T1 = Ix.*T0;
 
    num = W0.*(X2*H0' + wse*(X1*W0));
    den = ((P.^2).*(W0*H0))*H0' + wse*((((P.^2).*(T1*X))*X').*Ix)*W0 + lamda2*W0 + lamda1*(W0>0) +eps; 

    W = num./den;

    H = (H0.*(W'*((P.^2).*X)))./(W'*((P.^2).*(W*H0)) + lamda2*H0 + lamda1*(H0>0) + eps);

    delta_W = max(max(abs(W - W0)))/(sqrteps + max(max(abs(W0))));
    delta_H = max(max(abs(H - H0)))/(sqrteps + max(max(abs(H0))));

    W0 = W;
    H0 = H;
    
    i = i + 1;
    
    loss(i) = 0.5*norm(P.*(X-W0*H0),'fro')^2 + 0.25*wse*norm(P.*(X - (Ix.*(W0*W0'))*X),'fro')^2 + 0.5*lamda2*norm(H0,'fro')^2 + 0.5*lamda2*norm(W0,'fro')^2 + lamda1*norm(W,1) + lamda1*norm(H,1);
    
    delta = max(delta_W, delta_H);
end
[W,H,loss] = gather(W,H,loss);

end