import matplotlib
matplotlib.use('Agg')

import numpy as np
import scipy.stats as st
import statsmodels.datasets
import matplotlib.pyplot as plt

import pandas as pd
import scipy.optimize as spo
import numpy as np
from scipy.special import logsumexp
import time
import statistics
import math
from itertools import product
import pandas as pd
from matplotlib.ticker import MaxNLocator
data_set = 'Adults'

m=26
matplotlib.rcParams.update({'font.size': 18})
######################PLOT CORE###################
GC_core=np.zeros((21,2))
kmeans_core=np.zeros((21,2))
kmedoid_core=np.zeros((21,2))
it=40 #change for Iris
r=0
for k in range(5,m):
# Assuming 'results' is your matrix containing the data you saved
    results = pd.read_csv('k='+str(k)+'-'+data_set+'max.csv', header=None).values
    GC_core[r,0]=results[0][3]
    GC_core[r,1]=results[1][3]
    kmeans_core[r,0]= results[2][3]
    kmeans_core[r,1]= results[3][3]
    kmedoid_core[r,0]= results[4][3]
    kmedoid_core[r,1]= results[5][3]
    r+=1

x = [i for i in range(5, m)]

plt.plot(x,GC_core[:,0], label="Greedy Capture"   ,color='g', marker='o', linestyle='-',markersize=4, linewidth=0.8 )
ci = 1.96 * GC_core[:,1]/np.sqrt(it)
plt.fill_between(x, (GC_core[:,0]-ci), (GC_core[:,0]+ci), color='g', alpha=.1)

plt.plot(x,kmeans_core[:,0],label="k-means++"    ,color='r', marker='o', linestyle='-',markersize=4, linewidth=0.8 )
ci = 1.96 * kmeans_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmeans_core[:,0]-ci), (kmeans_core[:,0]+ci), color='r', alpha=.1)

plt.plot(x,kmedoid_core[:,0],label="k-medoids"    ,color='y', marker='o', linestyle='-',markersize=4, linewidth=0.8 )
ci = 1.96 * kmedoid_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmedoid_core[:,0]-ci), (kmedoid_core[:,0]+ci), color='y', alpha=.1)

plt.xlabel("k")
plt.xlim(4, m)
plt.gca().xaxis.set_major_locator(MaxNLocator(integer=True))
plt.rcParams['text.usetex'] = False

plt.xticks(np.arange(5, m, step=5))
#plt.ylim(top=4.2)

plt.ylabel("Core Violation")
#    plt.title("mu="+str(mu)+"sigma="+str(sigma)+", gamma="+str(gamma)+" and am="+str(am))
plt.tight_layout()
plt.legend(loc="upper left")
plt.savefig(f"core_{data_set}.pdf")
plt.savefig(f"core_{data_set}.png")

plt.clf()



######################PLOT FJR###################

# GC_core=np.zeros((16,2))
# kmeans_core=np.zeros((16,2))
# kmedoid_core=np.zeros((16,2))

r=0
for k in range(5,m):
# Assuming 'results' is your matrix containing the data you saved
    results = pd.read_csv('k='+str(k)+'-'+data_set+'max.csv', header=None).values
    GC_core[r,0]=results[0][2]
    GC_core[r,1]=results[1][2]
    kmeans_core[r,0]= results[2][2]
    kmeans_core[r,1]= results[3][2]
    kmedoid_core[r,0]= results[4][2]
    kmedoid_core[r,1]= results[5][2]
    r+=1

plt.plot(x,GC_core[:,0],label="Greedy Capture"    ,color='g', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * GC_core[:,1]/np.sqrt(it)
plt.fill_between(x, (GC_core[:,0]-ci), (GC_core[:,0]+ci), color='g', alpha=.1)


plt.plot(x,kmeans_core[:,0],label="k-means++"    ,color='r', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmeans_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmeans_core[:,0]-ci), (kmeans_core[:,0]+ci), color='r', alpha=.1)

plt.plot(x,kmedoid_core[:,0],label="k-medoids"    ,color='y', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmedoid_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmedoid_core[:,0]-ci), (kmedoid_core[:,0]+ci), color='y', alpha=.1)

plt.xlabel("k")
plt.xlim(4, 26)
plt.gca().xaxis.set_major_locator(MaxNLocator(integer=True))
plt.rcParams['text.usetex'] = False
#plt.ylim(top=4.2)
plt.xticks(np.arange(5, 26, step=5))

plt.ylabel("FJR Violation")
#    plt.title("mu="+str(mu)+"sigma="+str(sigma)+", gamma="+str(gamma)+" and am="+str(am))
plt.tight_layout()
plt.legend(loc="upper left")
plt.savefig(f"fjr_{data_set}.pdf")
plt.savefig(f"fjr_{data_set}.png")

plt.clf()





######################PLOT WITHIN CLUSTER###################
# GC_core=np.zeros((16,2))
# kmeans_core=np.zeros((16,2))
# kmedoid_core=np.zeros((16,2))

r=0
for k in range(5,m):
# Assuming 'results' is your matrix containing the data you saved
    results = pd.read_csv('k='+str(k)+'-'+data_set+'max.csv', header=None).values
    GC_core[r,0]=results[0][4]
    GC_core[r,1]=results[1][4]
    kmeans_core[r,0]= results[2][4]
    kmeans_core[r,1]= results[3][4]
    kmedoid_core[r,0]= results[4][4]
    kmedoid_core[r,1]= results[5][4]
    r+=1

plt.plot(x,GC_core[:,0],label="Greedy Capture"    ,color='g', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * GC_core[:,1]/np.sqrt(it)
plt.fill_between(x, (GC_core[:,0]-ci), (GC_core[:,0]+ci), color='g', alpha=.1)


plt.plot(x,kmeans_core[:,0],label="k-means++"    ,color='r', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmeans_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmeans_core[:,0]-ci), (kmeans_core[:,0]+ci), color='r', alpha=.1)

plt.plot(x,kmedoid_core[:,0],label="k-medoids"    ,color='y', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmedoid_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmedoid_core[:,0]-ci), (kmedoid_core[:,0]+ci), color='y', alpha=.1)
plt.ylim(bottom=0)


plt.xlabel("k")
plt.xlim(4, 26)

plt.gca().xaxis.set_major_locator(MaxNLocator(integer=True))
plt.rcParams['text.usetex'] = False

plt.xticks(np.arange(5, 26, step=5))
plt.ylabel("Cost")
#    plt.title("mu="+str(mu)+"sigma="+str(sigma)+", gamma="+str(gamma)+" and am="+str(am))
plt.tight_layout()
plt.legend(loc="lower left")
plt.savefig(f"cost_{data_set}.pdf")
plt.savefig(f"cost_{data_set}.png")

plt.clf()


######################PLOT KMEANS###################

# GC_core=np.zeros((16,2))
# kmeans_core=np.zeros((16,2))
# kmedoid_core=np.zeros((16,2))

r=0
for k in range(5,m):
# Assuming 'results' is your matrix containing the data you saved
    results = pd.read_csv('k='+str(k)+'-'+data_set+'max.csv', header=None).values
    GC_core[r,0]=results[0][5]
    GC_core[r,1]=results[1][5]
    kmeans_core[r,0]= results[2][5]
    kmeans_core[r,1]= results[3][5]
    kmedoid_core[r,0]= results[4][5]
    kmedoid_core[r,1]= results[5][5]
    r+=1

plt.plot(x,GC_core[:,0],label="Greedy Capture"    ,color='g', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * GC_core[:,1]/np.sqrt(it)
plt.fill_between(x, (GC_core[:,0]-ci), (GC_core[:,0]+ci), color='g', alpha=.1)


plt.plot(x,kmeans_core[:,0],label="k-means++"    ,color='r', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmeans_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmeans_core[:,0]-ci), (kmeans_core[:,0]+ci), color='r', alpha=.1)

plt.plot(x,kmedoid_core[:,0],label="k-medoids"    ,color='y', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmedoid_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmedoid_core[:,0]-ci), (kmedoid_core[:,0]+ci), color='y', alpha=.1)
plt.ylim(bottom=0)
plt.xlabel("k")
plt.xlim(4, 26)
plt.gca().xaxis.set_major_locator(MaxNLocator(integer=True))
plt.rcParams['text.usetex'] = False

plt.xticks(np.arange(5, 26, step=5))
plt.ylabel("k-means")

#    plt.title("mu="+str(mu)+"sigma="+str(sigma)+", gamma="+str(gamma)+" and am="+str(am))
plt.tight_layout()
plt.legend(loc="upper right")
plt.savefig(f"kmeans_{data_set}.pdf")
plt.savefig(f"kmeans_{data_set}.png")

plt.clf()


######################PLOT KMEDOIDS###################

# GC_core=np.zeros((16,2))
# kmeans_core=np.zeros((16,2))
# kmedoid_core=np.zeros((16,2))

r=0
for k in range(5,m):
# Assuming 'results' is your matrix containing the data you saved
    results = pd.read_csv('k='+str(k)+'-'+data_set+'max.csv', header=None).values
    GC_core[r,0]=results[0][6]
    GC_core[r,1]=results[1][6]
    kmeans_core[r,0]= results[2][6]
    kmeans_core[r,1]= results[3][6]
    kmedoid_core[r,0]= results[4][6]
    kmedoid_core[r,1]= results[5][6]
    r+=1


plt.plot(x,GC_core[:,0],label="Greedy Capture"    ,color='g', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * GC_core[:,1]/np.sqrt(it)
plt.fill_between(x, (GC_core[:,0]-ci), (GC_core[:,0]+ci), color='g', alpha=.1)


plt.plot(x,kmeans_core[:,0],label="k-means++"    ,color='r', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmeans_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmeans_core[:,0]-ci), (kmeans_core[:,0]+ci), color='r', alpha=.1)

plt.plot(x,kmedoid_core[:,0],label="k-medoids"    ,color='y', marker='o', linestyle='-',markersize=4, linewidth=0.8)
ci = 1.96 * kmedoid_core[:,1]/np.sqrt(it)
plt.fill_between(x, (kmedoid_core[:,0]-ci), (kmedoid_core[:,0]+ci), color='y', alpha=.1)
plt.ylim(bottom=0)
plt.xlabel("k")
plt.xlim(4, 26)
plt.gca().xaxis.set_major_locator(MaxNLocator(integer=True))
plt.rcParams['text.usetex'] = False

plt.xticks(np.arange(5, 26, step=5))
plt.ylabel("k-medoids")
#    plt.title("mu="+str(mu)+"sigma="+str(sigma)+", gamma="+str(gamma)+" and am="+str(am))
plt.legend(loc="lower left")
plt.tight_layout()
plt.savefig(f"kmedoids_{data_set}.pdf")
plt.savefig(f"kmedoids_{data_set}.png")

plt.clf()   