# Code for the paper Exploiting Certified Defences to Attack Randomised Smoothing
## Submitted by Anon, et. al for Neurips (2022)

### Summary

Code for constructing adversarial attacks, including by way of a new Certification Aware Attack framework, against models defended by Randomised Smoothing. Experiments performed against MNIST, CIFAR-10 and Tiny Imagenet. 

## License 

This code has been provided exclusively for the purposes of reviewing the attached work. Distribution, reproduction, or modification is strictly prohibited. Publication of this code will occur post-publication under a different license. 

### Dependencies

PyTorch >1.09
Numpy
Statsmodels

### Code Overview

**main.py** - Establishes and runs numerical experiments
**attacks.py** - Contains implementations of our Certification Aware Attack, PGD, DeepFool and Carlini-Wagner
**models.py** - Loads architectures
**datasets.py** - Loads datasets
**train.py** - Trains models
**./analysis/postprocessing.py** - Assess the performance of attacks

### Pre-Training

Tiny Imagenet can be downloaded http://cs231n.stanford.edu/tiny-imagenet-200.zip

To appropriately format the Tiny Imagenet dataset for PyTorch's inbuilt data loaders, the script *tinyimagenet_formatting.py* has been provided. 

### Training & Evaluation

#### Single GPU Training / Evaluation

Single GPU training/evaluation can be performed by running:

python3 main.py --dataset [mnist/cifar10/tinyimagenet] --train --eval --sigma [0.5/1.0] --samples 1500

##### Multi GPU Training / Evaluation

Multi-GPU training/evaluation can be performed by:

python3 main.py --dataset [mnist/cifar10/tinyimagenet] --train --eval --parallel always --sigma 0.5 --samples 1000


