import pandas as pd
import matplotlib.pyplot as plt
import numpy as np

test_path_sgd = r'logistic_regression/test_loss_sgd.csv'
test_path_gd = r'logistic_regression/test_loss_gd.csv'
test_path_svrg = r'logistic_regression/test_loss_svrg.csv'

train_path_sgd = r'logistic_regression/train_loss_sgd.csv'
train_path_gd = r'logistic_regression/train_loss_gd.csv'
train_path_svrg = r'logistic_regression/train_loss_svrg.csv'



test_losses_sgd = pd.read_csv(test_path_sgd,header=None)
test_losses_gd = pd.read_csv(test_path_gd,header=None)
test_losses_svrg = pd.read_csv(test_path_svrg,header=None)

training_losses_sgd = pd.read_csv(train_path_sgd,header=None)
training_losses_gd = pd.read_csv(train_path_gd,header=None)
training_losses_svrg = pd.read_csv(train_path_svrg,header=None)



# plt.plot(training_losses_sgd, label='Training Loss (ZO-SGD)')
# plt.plot(test_losses_sgd, label='Test Loss (ZO-SGD)')
# plt.plot(training_losses_svrg, label='Training Loss (ZO-SVRG)')
# plt.plot(test_losses_svrg, label='Test Loss (ZO-SVRG)')
# plt.plot(training_losses_gd, label='Training Loss (ZO-GD)')
# plt.plot(test_losses_gd, label='Test Loss (ZO-GD)')

plt.plot(np.abs(np.array(training_losses_sgd) - np.array(test_losses_sgd)), label='Generalization Error (ZO-SGD)')
plt.plot(np.abs(np.array(training_losses_svrg) - np.array(test_losses_svrg)), label='Generalization Error (ZO-SVRG)')
plt.plot(np.abs(np.array(training_losses_gd) - np.array(test_losses_gd)), label='Generalization Error (ZO-GD)')

plt.xlabel('Epoches')
plt.ylabel('abs(test loss - train loss)')

plt.legend()
plt.show()

