from gymnasium import Env

from tianshou.env import BaseVectorEnv
#tianshou
from examples.atari.atari_wrapper import AtariEnvFactory
from tianshou.highlevel.env import EnvMode


def make_atari_env(
    task: str,
    seed: int,
    training_num: int,
    test_num: int,
    scale: int | bool = False,
    frame_stack: int = 4,
    create_watch_env: bool = False,
    *args,
    **kwargs
) -> tuple[Env, BaseVectorEnv, BaseVectorEnv, BaseVectorEnv]:
    """Wrapper function for Atari env.

    If EnvPool is installed, it will automatically switch to EnvPool's Atari env.

    :return: a tuple of (single env, training envs, test envs).
    """
    env_factory = AtariEnvFactory(task, seed, seed + training_num, frame_stack, scale=bool(scale))
    envs = env_factory.create_envs(training_num, test_num)

    #Apparently we need to remove envpool to have render
    watch_env = None
    if create_watch_env:
        watch_env_factory = AtariEnvFactory(task, seed, seed + training_num, frame_stack, scale=bool(scale),
                                            use_envpool_if_available=False)
        watch_env = watch_env_factory.create_env(EnvMode.WATCH)

    return envs.env, envs.train_envs, envs.test_envs, watch_env

