from collections import OrderedDict

import numpy as np
from mo_gymnasium.envs.breakable_bottles.breakable_bottles import BreakableBottles


class CustomBreakableBottles(BreakableBottles):

    def __init__(self, *args, **kwargs):

        super().__init__(*args, **kwargs)

        # TODO: remove this workaround when tianshou stops expecting OrderedDict
        self.observation_space.spaces = OrderedDict(self.observation_space.spaces)

    def _get_obs(self):
        return {
            "location": np.array(self.location, dtype=np.int32),
            "bottles_carrying": np.array(self.bottles_carrying, dtype=np.int32),
            "bottles_delivered": np.array(self.bottles_delivered, dtype=np.int32),
            "bottles_dropped": np.array(self.bottles_dropped.copy(), dtype=np.int8),
        }