import copy

import numpy as np


def defaultdict_to_dict(d, seen=None):
    if seen is None:
        seen = {}

    obj_id = id(d)
    if obj_id in seen:
        return seen[obj_id]

    if isinstance(d, dict):
        result = {}
        seen[obj_id] = result
        for k, v in d.items():
            result[k] = defaultdict_to_dict(v, seen)
        return result
    return d

def dict_to_defaultdict(d, factory_list, seen=None):
    if len(factory_list) == 0:
        return d

    if seen is None:
        seen = {}

    obj_id = id(d)
    if obj_id in seen:
        return seen[obj_id]

    if not isinstance(d, dict):
        return d

    def _func(a):
        x = a[-1]
        for i in range(-2, -len(a) - 1, -1):
            x = (lambda i, x: lambda: a[i](x))(i, x)
        return x()

    factory_list = copy.copy(factory_list)
    dd = _func(factory_list)
    seen[obj_id] = dd  # Pre-store to handle recursion
    factory_list.pop(0)

    for k, v in d.items():
        dd[k] = dict_to_defaultdict(v, factory_list, seen)

    return dd

def entry_or_none(d, item_list):
    temp = d
    for item in item_list:
        temp = temp.get(item)
        if temp is None:
            return None

    return temp

def np_concatenate(arg_list):

    non_empty = [a for a in arg_list if len(a) > 0]

    if len(non_empty) == 0:
        return np.array([])

    return np.concatenate(non_empty)

def reference_preserving_copy(source, target):
    if source is target:
        return
    if hasattr(source, '__dict__') and hasattr(target, '__dict__'):
        target.__dict__.clear()
        for key, value in vars(source).items():
            setattr(target, key, value)
    elif isinstance(source, dict) and isinstance(target, dict):
        target.clear()
        for key, value in source.items():
            target[key] = value
    else:
        raise TypeError("Unsupported types for reference_preserving_copy")
