import json

import numpy as np


def custom_serializer(obj):
    if isinstance(obj, np.ndarray):
        return obj.tolist()  # convert array to list
    if isinstance(obj, np.float32):
        return float(obj)  # Convert to Python float
    raise TypeError(f"Type {type(obj)} not serializable")


def encode_dict_with_tuple_keys(d):
    """Convert tuple keys into JSON-safe strings."""
    return {
        json.dumps(k) if isinstance(k, tuple) else k: v
        for k, v in d.items()
    }

def decode_dict_with_tuple_keys(d):
    """Convert JSON-safe keys back into tuples."""
    new_d = {}
    for k, v in d.items():
        try:
            parsed_key = json.loads(k)
            if isinstance(parsed_key, list):
                parsed_key = tuple(parsed_key)
            new_d[parsed_key] = v
        except (json.JSONDecodeError, TypeError):
            new_d[k] = v
    return new_d

