import os

from tianshou.utils import WandbLogger, TensorboardLogger
from torch.utils.tensorboard import SummaryWriter


def get_logger(args, log_path, log_name):

    writer = SummaryWriter(log_path)
    writer.add_text("args", str(args))

    if args.logger == "tensorboard":
        logger = TensorboardLogger(writer)
    elif args.logger == "wandb":
        logger = WandbLogger(
            save_interval=1,
            name=log_name.replace(os.path.sep, "__"),
            run_id=args.resume_id,
            config=args,
            project=args.wandb_project,
        )
        logger.load(writer)
    else:
        raise ValueError("Invalid logger")

    return logger
