import time
from contextlib import contextmanager

stop_all = True
supress_all = False
tracking = {}

@contextmanager
def timing(label="Execution time", supress_printing=False, stop=False, keep_tracking=True, threshold=None):
    start = time.perf_counter()
    yield
    if stop or stop_all:
        return
    end = time.perf_counter()

    if keep_tracking:
        if label not in tracking:
            tracking[label] = {
                "times": 0,
                "avg": 0
            }
        tracking[label].update({
            "time": end - start,
            "times": tracking[label]['times'] + 1
        })
        tracking[label].update({
            "avg": tracking[label]['avg'] + ((end - start) - tracking[label]['avg']) / tracking[label]['times']
        })
        tracking[label].update({
            "improv": 1 - (end - start) / tracking[label]['avg']
        })
        if not supress_printing and not supress_all:
            # if threshold and (end - start) > threshold:
            print(f"{label}: {end - start:.6f} seconds | avg: {tracking[label]['avg']:.6f} | {tracking[label]['improv']:.6f} times over average")
    else:
        if not supress_printing and not supress_all:
            # if threshold and (end - start) > threshold:
            print(f"{label}: {end - start:.6f} seconds")

    return
