#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
. "$SCRIPT_DIR/utils/parallel_utils.sh"
cd "$SCRIPT_DIR/../../multi_policy_morl_ec"

MAX_SCRIPT_JOBS="$1"

TASK="$2"
TASK_PARAMS="$3"
TASK_WRAPPER="$4"
MAX_TRAJECTORY_LENGTH="$5"

SEED="$6"

COMMANDS=(
"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as3' --log-name 'as3_trajectory_length_off' --results-dir './../paper/ablation/$TASK/results/as3' \
--debug --as3 --debug-disable-trajectory-length --debug-track-policies \
--max-trajectory-length \"$MAX_TRAJECTORY_LENGTH\""
)

# Launch commands with concurrency limit
for cmd in "${COMMANDS[@]}"; do
    run_exp "$cmd" "$MAX_SCRIPT_JOBS"
done

wait
echo "as3 finished"
