#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
. "$SCRIPT_DIR/utils/parallel_utils.sh"
cd "$SCRIPT_DIR/../../multi_policy_morl_ec"

MAX_SCRIPT_JOBS="$1"

TASK="$2"
TASK_PARAMS="$3"
TASK_WRAPPER="$4"
MAX_TRAJECTORY_LENGTH="$5"

SEED="$6"

COMMANDS=(
"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as4' --log-name 'as4_average_reward_off' --results-dir './../paper/ablation/$TASK/results/as4' \
--debug --as4 --debug-disable-average-reward --debug-learning-rate 0.1 --debug-discount-factor 1 --debug-track-policies \
--max-trajectory-length \"$MAX_TRAJECTORY_LENGTH\""
)

# Launch commands with concurrency limit
for cmd in "${COMMANDS[@]}"; do
    run_exp "$cmd" "$MAX_SCRIPT_JOBS"
done

wait
echo "as4 finished"
