#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
. "$SCRIPT_DIR/utils/parallel_utils.sh"
cd "$SCRIPT_DIR/../../multi_policy_morl_ec"

MAX_SCRIPT_JOBS="$1"

TASK="$2"
TASK_PARAMS="$3"
TASK_WRAPPER="$4"
MAX_TRAJECTORY_LENGTH="$5"

SEED="$6"

COMMANDS=(
"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --stationary --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as5' --log-name 'as5_cycle_detection_off' --results-dir './../paper/ablation/$TASK/results/as5' \
--debug --as5 --debug-disable-cycle-detection --debug-track-trajectories-length \
--max-trajectory-length \"$MAX_TRAJECTORY_LENGTH\""
)

# Launch commands with concurrency limit
for cmd in "${COMMANDS[@]}"; do
    run_exp "$cmd" "$MAX_SCRIPT_JOBS"
done

wait
echo "as5 finished"
