#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
. "$SCRIPT_DIR/utils/parallel_utils.sh"
cd "$SCRIPT_DIR/../../multi_policy_morl_ec"

MAX_SCRIPT_JOBS="$1"

TASK="$2"
TASK_PARAMS="$3"
TASK_WRAPPER="$4"
MAX_TRAJECTORY_LENGTH="$5"

SEED="$6"

COMMANDS=(
"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as6' --log-name 'as6_l_30' --results-dir './../paper/ablation/$TASK/results/as6' \
--debug --as6 --debug-track-trajectories-length \
--max-trajectory-length 30"

"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as6' --log-name 'as6_l_20' --results-dir './../paper/ablation/$TASK/results/as6' \
--debug --as6 --debug-track-trajectories-length \
--max-trajectory-length 20"

"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as6' --log-name 'as6_l_10' --results-dir './../paper/ablation/$TASK/results/as6' \
--debug --as6 --debug-track-trajectories-length \
--max-trajectory-length 10"

"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as6' --log-name 'as6_l_5' --results-dir './../paper/ablation/$TASK/results/as6' \
--debug --as6 --debug-track-trajectories-length \
--max-trajectory-length 5"

"python3 src/run.py mpec_discrete --task \"$TASK\" \
--task-params \"$TASK_PARAMS\" --task-wrapper \"$TASK_WRAPPER\" --epoch 1 \
--seed \"$SEED\" \
--logdir './../paper/ablation/$TASK/log/as6' --log-name 'as6_l_2' --results-dir './../paper/ablation/$TASK/results/as6' \
--debug --as6 --debug-track-trajectories-length \
--max-trajectory-length 2"
)

# Launch commands with concurrency limit
for cmd in "${COMMANDS[@]}"; do
    run_exp "$cmd" "$MAX_SCRIPT_JOBS"
done

wait
echo "as6 finished"
