import numpy as np
from matplotlib import pyplot as plt
from matplotlib.legend_handler import HandlerBase
from matplotlib.lines import Line2D
from matplotlib.patches import PathPatch
from matplotlib.path import Path


def add_figure_label(fig, label):
    fig.text(0.01, 0.98, label, fontsize=16, fontweight='bold', va='top', ha='left')


class HandlerCurvedFlatTopViolin(HandlerBase):
    def create_artists(self, legend, orig_handle,
                       xdescent, ydescent, width, height,
                       fontsize, trans):
        y_offset = -0.4 * height  # shift everything down

        top_y = ydescent - height * 0.05 + y_offset
        dip_y = ydescent + height * 0.2 + y_offset # how far the curve dips

        # Path with flat top + two downward curves
        verts = [
            (xdescent, top_y),                        # left start
            (xdescent + width*0.1, dip_y),            # left curve control
            (xdescent + width*0.25, dip_y),           # left curve bottom
            (xdescent + width*0.25, dip_y),           # join bottom
            (xdescent + width*0.75, dip_y),           # straight across bottom
            (xdescent + width*0.9, dip_y),            # right curve control
            (xdescent + width, top_y),                # right end
        ]
        codes = [
            Path.MOVETO,
            Path.CURVE3, Path.CURVE3,   # left curve
            Path.LINETO,                # bottom
            Path.LINETO,                # continue bottom
            Path.CURVE3, Path.CURVE3    # right curve
        ]

        path = Path(verts, codes)
        violin_top = PathPatch(path, lw=2, edgecolor="gray", facecolor="none",
                               transform=trans)

        # Add "#" above the flat section
        txt = plt.Text(xdescent + width/2,
                       top_y + height*0.30,
                       "#", ha="center", va="bottom",
                       fontsize=fontsize, color="black", fontweight='bold',
                       transform=trans)

        return [violin_top, txt]

class HandlerRulerWithHashBelow(HandlerBase):
    def create_artists(self, legend, orig_handle,
                       xdescent, ydescent, width, height,
                       fontsize, trans):
        # Geometry
        line_y = ydescent + height * 0.5  # position of ruler line
        hash_y = line_y - height * 0.3    # position of # below the line

        # Compute vertical center of the symbol
        symbol_center = (line_y + hash_y) / 2
        target_center = ydescent + height * 0.5
        y_shift = target_center - symbol_center

        # Additional downward shift
        y_shift_down = - 0.3 * height
        line_y += y_shift + y_shift_down
        hash_y += y_shift + y_shift_down

        # Black horizontal line (ruler)
        line = Line2D([xdescent, xdescent + width], [line_y, line_y],
                      color="black", lw=2, transform=trans)

        # # symbol below the line
        txt = plt.Text(xdescent + width/2, hash_y, "#",
                       ha="center", va="top", fontsize=fontsize,
                       color="black", transform=trans)

        return [line, txt]


import numpy as np


