
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
. "$SCRIPT_DIR/utils/parallel_utils.sh"

TASK="deep-sea-treasure-v0"
TASK_WRAPPER="DeepSeaTeleportToTheStart:terminate_after_n_episodes=False"
MAX_TRAJECTORY_LENGTH=30

#TASK="fruit-tree-v0"
#TASK_PARAMS="depth=5"
#TASK_WRAPPER="FruitTreeTeleportToTheStart:terminate_after_n_episodes=2"
#MAX_TRAJECTORY_LENGTH=10

MAX_JOBS=5
MAX_SCRIPT_JOBS=2


ABLATION_STUDIES=("as5")
SEEDS=(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19)

#./"$ABLATION_STUDY".sh "$MAX_SCRIPT_JOBS" "$TASK" "$TASK_WRAPPER" "$MAX_TRAJECTORY_LENGTH"

# Create log folder
LOG_FOLDER="$SCRIPT_DIR/$TASK/as_log"
mkdir -p "$LOG_FOLDER"

for ablation in "${ABLATION_STUDIES[@]}"; do
    script="$SCRIPT_DIR/$ablation.sh"
    for seed in "${SEEDS[@]}"; do
        echo "Launching $(basename "$script") with seed $seed..."
        logfile="$LOG_FOLDER/$(basename "$script")_seed_$seed.log"

        (
          "$script" "$MAX_SCRIPT_JOBS" "$TASK" "$TASK_PARAMS" "$TASK_WRAPPER" "$MAX_TRAJECTORY_LENGTH" "$seed" > "$logfile" 2>&1
          echo "$(basename "$script") finished (seed "$seed")"
        ) &

        sleep 1

        # Wait if we reach the max number of jobs
        while [ "$(num_jobs)" -ge "$MAX_JOBS" ]; do
            sleep 1
        done
    done
done

wait

echo "All experiments finished"
