#!/bin/sh

trap '
  if [ "$$" -eq "$BASHPID" ]; then
    echo "Killing all experiments..."
  fi
  kill -- -$$
  exit 1
' INT

# Count background jobs
num_jobs() {
    jobs -pr | wc -l
}

# Run a command with concurrency limit
# Usage: run_exp "command string" MAX_JOBS
run_exp() {
    CMD="$1"
    MAX_SCRIPT_JOBS="$2"

    echo "$CMD"
    sh -c "$CMD" &

    # Wait if max jobs reached
    while [ "$(num_jobs)" -ge "$MAX_SCRIPT_JOBS" ]; do
        sleep 1
    done
}