# Bridging GNNs and MLPs with Self-Supervised Learning

---

## Introduction

---

We propose Graph-free Contrastive Learning (GreeCo) to embed rich structural information MLPs and enhance model generalization using contrative learning. 

<img src="GreeCo.png">


## Usage

---

### Node Classification

- **Transductive Setting**

```
python main.py --setting trans --dataset cora --use_params
```

- **Inductive Setting** (Production Setting)

```
python main.py --setting ind --dataset cora --use_params
```

### Graph Classification

```
python main_graph.py --dataset collab --use_params
```

### Supervised GreeCo

```
python main_sup.py --dataset cora --use_params
```