from ODE.Get_MultiEst import *
import numpy as np
import matplotlib.pyplot as plt
import matplotlib
matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42
import seaborn as sns
import pandas as pd
import os


print(os.getcwd())
CFdata = pd.read_csv(r"./ODE_CF.csv", header=None)
QMCdata = pd.read_csv(r"./ODE_Halton.csv", header=None)
MCdata = pd.read_csv(r'./ODE_MC.csv', header=None)
LHSdata = pd.read_csv(r"./ODE_LHS.csv", header=None)
N_runs=100
ref = -4.220413874076402

CFE = Get_Output(CFdata,types=0,N_budget=3,N_runs=N_runs,L=1,l=1)-ref
MLBMCE = Get_Output(MCdata,types=0,N_budget=3,N_runs=N_runs,L=3,l=3)-ref
MLMCE = Get_Output(MCdata,types=1,N_budget=3,N_runs=N_runs,L=3,l=3)-ref
QMCE = Get_Output(QMCdata,types=0,N_budget=3,N_runs=N_runs,L=3,l=3)-ref
LHSE = Get_Output(LHSdata,types=0,N_budget=3,N_runs=N_runs,L=3,l=3)-ref


fig = plt.figure(figsize=(7,4))
sns.set_style("ticks")
Sample_Cons = ["0.30","0.91","1.52"]
plt.rcParams['font.size'] = '15'

Err=pd.DataFrame(columns=["Budget T (s)","Estimator","Absolute Error"])

for i in range(3):
    data = {
        "Budget T (s)": np.repeat(Sample_Cons[i], N_runs*5),
        "Estimator": np.repeat([ "MLCF QMC","MLCF LHS","MLCF IID",  "MLMC", "CF IID"], N_runs),
        "Absolute Error": np.concatenate(
            ( np.abs(QMCE[i,0:]), np.abs(LHSE[i,0:]), np.abs(MLBMCE[i,0:]),np.abs(MLMCE[i,0:]),np.abs(CFE[i,0:])))
    }
    df=pd.DataFrame(data)
    Err = pd.concat([Err, df], ignore_index=True)

colors = ["lightgreen","lightseagreen","deepskyblue","palevioletred","plum"]
sns.set_palette(sns.color_palette(colors))
g1=sns.boxplot(x="Budget T (s)", y="Absolute Error", hue="Estimator", data=Err)
plt.xlabel('Budget T (s)', fontsize=18)
plt.ylabel('Absolute Error', fontsize=18)

plt.tight_layout()
plt.savefig("ODE_Plot.pdf",dpi=600)
plt.show()
