import numpy as np
import matplotlib.pyplot as plt
import matplotlib
import seaborn as sns
import pandas as pd


est1 = np.load("./TestBed_Est1.npy")
est3 = np.load("./TestBed_Est3.npy")
est4 = np.load("./TestBed_Est4.npy")
est5 = np.load("./TestBed_Est5.npy")

ref = 10*1.+3*0.5+1*0.15

err1 = np.abs(ref - np.sum(est1,2))
err3 = np.abs(ref - np.sum(est3,2))
err4 = np.abs(ref - np.sum(est4,2))
err5 = np.abs(ref - est5)

matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42

sns.set_style("ticks")

Sample_Cons = ["low", "medium", "high"]
N_runs = err1.shape[0]

Err = pd.DataFrame(columns=["Budget T", "Estimator", "Absolute Error"])

for i in range(3):
    data = {
        "Budget T": np.repeat(Sample_Cons[i], N_runs * 4),
        "Estimator": np.repeat(['MLCF $n_{MLCF}$',  'MLCF $n_{MLMC}$', 'MLMC $n_{MLMC}$', "CF"], N_runs),
        "Absolute Error": np.concatenate((
            np.abs(err1[:, i]),
            np.abs(err3[:, i]),
            np.abs(err4[:, i]),
            np.abs(err5[:, i])
        ))
    }
    df = pd.DataFrame(data)
    Err = pd.concat([Err, df], ignore_index=True)


colors =  ["deepskyblue","palevioletred","plum","lightgreen"]
sns.set_palette(sns.color_palette(colors))

plt.figure(figsize=(6, 6))
plt.rcParams['font.size'] = 15

g1 = sns.boxplot(x="Budget T", y="Absolute Error", hue="Estimator", data=Err)

g1.set(yscale="log")

plt.xlabel('Budget T', fontsize=18)
plt.ylabel('Absolute Error', fontsize=18)

plt.tight_layout()
plt.savefig("TestBed_Error_Boxplot.pdf", bbox_inches='tight', dpi=300)
plt.show()

