from illustrative.fl import  *
import torch
import numpy as np
from mlcf.cf_estimator import *
import random
def set_seed(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)

set_seed(200)


n = [[11,4,3],[14,11,4],[23,17,5]]
iter = 50
L = 3
est = np.zeros((iter,3,L))

for l in range(3):
    for j in range(3):
        for i in range(iter):

            X_te = torch.distributions.Uniform(0, 1).sample((n[j][l],))
            X_te = torch.tensor(X_te).unsqueeze(1).float()
            if l == 0:
                Y_te = f0(X_te)
            elif l == 1:
                Y_te = f1(X_te) - f0(X_te)
            else:
                Y_te = f2(X_te) - f1(X_te)
            Y_te = torch.tensor(Y_te)
            est[i,j,l] = Y_te.mean().item()

np.save("MLMC_repetition.npy", est)
