import numpy as np
import matplotlib.pyplot as plt
import matplotlib
import seaborn as sns
import pandas as pd
from illustrative.fl import *


est1 = np.load("MLCF_repetition.npy")
est2 = np.load("MLMC_repetition.npy")
est5 = np.load("CF_repetition.npy")

tgrid = np.linspace(0,1,10000)
ygrid  = f2(tgrid )
ref = np.mean(ygrid)


err1 = np.abs(ref - np.sum(est1,2))
err2 = np.abs(ref - np.sum(est2,2))
err5 = np.abs(ref - est5)

matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42
plt.rcParams['font.size'] = '15'

sns.set_style("ticks")

Sample_Cons = ["low", "medium", "high"]
N_runs = err1.shape[0]

Err = pd.DataFrame(columns=["Budget T", "Estimator", "Absolute Error"])

for i in range(3):
    data = {
        "Budget T (s)": np.repeat(Sample_Cons[i], N_runs * 3),
        "Estimator": np.repeat(['MLCF ', "CF","MLMC"], N_runs),
        "Absolute Error": np.concatenate((
            np.abs(err1[:, i]),
            np.abs(err5[:, i]),
            np.abs(err2[:, i]),
        ))
    }
    df = pd.DataFrame(data)
    Err = pd.concat([Err, df], ignore_index=True)

colors = ["deepskyblue", "plum", "lightgreen"]
sns.set_palette(sns.color_palette(colors))

plt.figure(figsize=(6, 6))
plt.rcParams['font.size'] = 17

g1 = sns.boxplot(x="Budget T (s)", y="Absolute Error", hue="Estimator", data=Err)

g1.set(yscale="log")

plt.xlabel('Budget T (s)', fontsize=18)
plt.ylabel('Absolute Error', fontsize=18)

plt.tight_layout()
plt.savefig("Illustrate_Error_Boxplot.pdf", bbox_inches='tight', dpi=300)
plt.show()

