import numpy as np

def euler_solve(f, h, y0=1.0, t0=0.0, T=1.0):
    N = int(np.ceil((T - t0) / h))
    t_grid = t0 + np.arange(N + 1) * h
    t_grid[-1] = T

    y_grid = np.zeros(N + 1)
    y_grid[0] = y0
    for n in range(N):
        dt = t_grid[n + 1] - t_grid[n]
        y_grid[n + 1] = y_grid[n] + dt * f(t_grid[n], y_grid[n])

    def y_l(tau):
        tau = np.asarray(tau)
        tau = np.clip(tau, t_grid[0], t_grid[-1])
        return np.interp(tau, t_grid, y_grid)

    return t_grid, y_grid, y_l

f = lambda t, y: -y
t0, y0, f0 = euler_solve(f, h=0.25)
t1, y1, f1 = euler_solve(f, h=0.05)
t2, y2, f2 = euler_solve(f, h=0.005)
